/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.multiple.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import com.openexchange.groupware.AbstractOXException;
import com.openexchange.mailaccount.json.multiple.MailAccountMultipleHandlerFactory;
import com.openexchange.multiple.handlers.AppointmentFactoryService;
import com.openexchange.multiple.handlers.ConfigFactoryService;
import com.openexchange.multiple.handlers.ContactsFactoryService;
import com.openexchange.multiple.handlers.GroupFactoryService;
import com.openexchange.multiple.handlers.QuotaFactoryService;
import com.openexchange.multiple.handlers.ReminderFactoryService;
import com.openexchange.multiple.handlers.ResourceFactoryService;
import com.openexchange.multiple.handlers.TasksFactoryService;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;

/**
 * {@link MultipleHandlerInit} - Initialization for multiple handlers.
 * <p>
 * Should be done in activator if refactored to reside in own package.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class MultipleHandlerInit implements Initialization {

    private final AtomicBoolean started;

    /**
     * Initializes a new {@link MultipleHandlerInit}.
     */
    public MultipleHandlerInit() {
        super();
        started = new AtomicBoolean();
    }

    public void start() throws AbstractOXException {
        if (!started.compareAndSet(false, true)) {
            return;
        }
        final MultipleHandlerRegistry registry = new MultipleHandlerRegistryImpl();
        ServerServiceRegistry.getInstance().addService(MultipleHandlerRegistry.class, registry);
        /*
         * Add known handlers
         */
        registry.addFactoryService(new QuotaFactoryService());
        registry.addFactoryService(new AppointmentFactoryService());
        registry.addFactoryService(new ContactsFactoryService());
        registry.addFactoryService(new GroupFactoryService());
        registry.addFactoryService(new ReminderFactoryService());
        registry.addFactoryService(new ResourceFactoryService());
        registry.addFactoryService(new TasksFactoryService());
        registry.addFactoryService(new ConfigFactoryService());
        registry.addFactoryService(new MailAccountMultipleHandlerFactory());
    }

    public void stop() throws AbstractOXException {
        if (!started.compareAndSet(true, false)) {
            return;
        }
        ServerServiceRegistry.getInstance().removeService(MultipleHandlerRegistry.class);
    }

}
