/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.consistency.osgi;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.consistency.ConsistencyException;
import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.consistency.MBeanNamer;
import com.openexchange.consistency.OsgiOXConsistency;
import com.openexchange.management.ManagementException;
import com.openexchange.management.ManagementService;

/**
 * {@link MBeanRegisterer}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class MBeanRegisterer implements ServiceTrackerCustomizer {

    private static final Log LOG = LogFactory.getLog(MBeanRegisterer.class);

    private final BundleContext context;

    private ObjectName name;

    public MBeanRegisterer(BundleContext context) {
        super();
        this.context = context;
    }

    public Object addingService(ServiceReference reference) {
        ManagementService managementService = (ManagementService) context.getService(reference);
        try {
            name = MBeanNamer.getName();
            LOG.info("Registering consistency MBean under name: " + name);
            managementService.registerMBean(name, new OsgiOXConsistency());
        } catch (ManagementException e) {
            ConsistencyException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e);
            LOG.error(e1.getMessage(), e1);
        } catch (MalformedObjectNameException e) {
            ConsistencyException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e);
            LOG.error(e1.getMessage(), e1);
        } catch (NullPointerException e) {
            ConsistencyException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e);
            LOG.error(e1.getMessage(), e1);
        }
        return managementService;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        // Nothing to do.
    }

    public void removedService(ServiceReference reference, Object service) {
        ManagementService managementService = (ManagementService) service;
        LOG.info("Unregistering consistency MBean with name " + name);
        try {
            managementService.unregisterMBean(name);
        } catch (ManagementException e) {
            ConsistencyException e1 = ConsistencyExceptionCodes.UNREGISTRATION_FAILED.create(e);
            LOG.error(e1.getMessage(), e1);
        }
        name = null;
        context.ungetService(reference);
    }
}
