/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.EventAdapter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ConfigurationEventAdapter
extends EventAdapter {
    public static final String HEADER = "org/osgi/service/cm/ConfigurationEvent";
    public static final String CM_UPDATED = "CM_UPDATED";
    public static final String CM_DELETED = "CM_DELETED";
    public static final String CM_FACTORY_PID = "cm.factoryPid";
    public static final String CM_PID = "cm.pid";
    private ConfigurationEvent event;

    public ConfigurationEventAdapter(ConfigurationEvent event, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.event = event;
    }

    public Event convert() {
        String typename = null;
        switch (this.event.getType()) {
            case 1: {
                typename = CM_UPDATED;
                break;
            }
            case 2: {
                typename = CM_DELETED;
                break;
            }
            default: {
                return null;
            }
        }
        String topic = "org/osgi/service/cm/ConfigurationEvent/" + typename;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ServiceReference ref = this.event.getReference();
        if (ref == null) {
            throw new RuntimeException("ServiceEvent.getServiceReference() is null");
        }
        properties.put(CM_PID, this.event.getPid());
        if (this.event.getFactoryPid() != null) {
            properties.put(CM_FACTORY_PID, this.event.getFactoryPid());
        }
        this.putServiceReferenceProperties(properties, ref);
        Event converted = new Event(topic, properties);
        return converted;
    }
}

