/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event;

import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.event.EventAdminMsg;
import org.eclipse.equinox.event.EventHandlerTracker;
import org.eclipse.equinox.event.EventHandlerWrapper;
import org.eclipse.equinox.event.LogTracker;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;

public class EventAdminImpl
implements EventAdmin {
    private final LogTracker log;
    private final EventHandlerTracker handlers;
    private volatile EventManager eventManager;

    EventAdminImpl(BundleContext context) {
        this.log = new LogTracker(context, System.out);
        this.handlers = new EventHandlerTracker(context, this.log);
    }

    void start() {
        this.log.open();
        this.eventManager = new EventManager(EventAdminMsg.EVENT_ASYNC_THREAD_NAME);
        this.handlers.open();
    }

    void stop() {
        this.handlers.close();
        this.eventManager.close();
        this.eventManager = null;
        this.log.close();
    }

    public void postEvent(Event event) {
        this.dispatchEvent(event, true);
    }

    public void sendEvent(Event event) {
        this.dispatchEvent(event, false);
    }

    private void dispatchEvent(Event event, boolean isAsync) {
        EventManager currentManager = this.eventManager;
        if (currentManager == null) {
            return;
        }
        if (event == null) {
            this.log.log(1, EventAdminMsg.EVENT_NULL_EVENT);
        }
        String topic = event.getTopic();
        try {
            this.checkTopicPermissionPublish(topic);
        }
        catch (SecurityException e) {
            String msg = NLS.bind((String)EventAdminMsg.EVENT_NO_TOPICPERMISSION_PUBLISH, (Object)event.getTopic());
            this.log.log(1, msg);
            throw e;
        }
        Set eventHandlers = this.handlers.getHandlers(topic);
        if (eventHandlers.size() == 0) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        TopicPermission perm = sm == null ? null : new TopicPermission(topic, "subscribe");
        EventListeners listeners = new EventListeners();
        Iterator iter = eventHandlers.iterator();
        while (iter.hasNext()) {
            EventHandlerWrapper wrapper = (EventHandlerWrapper)iter.next();
            listeners.addListener((Object)wrapper, (Object)perm);
        }
        ListenerQueue listenerQueue = new ListenerQueue(currentManager);
        listenerQueue.queueListeners(listeners, (EventDispatcher)this.handlers);
        if (isAsync) {
            listenerQueue.dispatchEventAsynchronous(0, (Object)event);
        } else {
            listenerQueue.dispatchEventSynchronous(0, (Object)event);
        }
    }

    private void checkTopicPermissionPublish(String topic) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission((Permission)new TopicPermission(topic, "publish"));
    }
}

