/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.rmi.dataobjects;

import com.openexchange.admin.rmi.dataobjects.ExtendableDataObject;
import com.openexchange.admin.rmi.dataobjects.NameAndIdObject;
import com.openexchange.admin.rmi.extensions.OXCommonExtension;
import com.openexchange.admin.rmi.extensions.OXResourceExtensionInterface;
import java.lang.reflect.Field;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends ExtendableDataObject
implements NameAndIdObject {
    private static final long serialVersionUID = 6549687169790363728L;
    private Integer id;
    private String name;
    private boolean nameset;
    private String displayname;
    private boolean displaynameset;
    private String description;
    private boolean descriptionset;
    private String email;
    private boolean emailset;
    private Boolean available;
    private boolean availableset;

    public Resource() {
        this.init();
    }

    public Resource(Integer id) {
        this.init();
        this.id = id;
    }

    private void init() {
        this.initExtendable();
        this.id = null;
        this.name = null;
        this.displayname = null;
        this.description = null;
        this.email = null;
        this.available = null;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.nameset = true;
        this.name = name;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displaynameset = true;
        this.displayname = displayname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.emailset = true;
        this.email = email;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.availableset = true;
        this.available = available;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.descriptionset = true;
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[ \n");
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                Object ob = f.get(this);
                String tname = f.getName();
                if (ob == null || tname.equals("serialVersionUID")) continue;
                ret.append("  ");
                ret.append(tname);
                ret.append(": ");
                ret.append(ob);
                ret.append("\n");
            }
            catch (IllegalArgumentException e) {
                ret.append("IllegalArgument\n");
            }
            catch (IllegalAccessException e) {
                ret.append("IllegalAccessException\n");
            }
        }
        ret.append("]");
        return ret.toString();
    }

    public void addExtension(OXResourceExtensionInterface extension) {
        this.getAllExtensionsAsHash().put(extension.getClass().getName(), (OXCommonExtension)((Object)extension));
    }

    public ArrayList<OXResourceExtensionInterface> getExtensions() {
        ArrayList<OXResourceExtensionInterface> retval = new ArrayList<OXResourceExtensionInterface>();
        for (OXCommonExtension commoninterface : this.getAllExtensionsAsHash().values()) {
            retval.add((OXResourceExtensionInterface)((Object)commoninterface));
        }
        return retval;
    }

    public boolean removeExtension(OXResourceExtensionInterface o) {
        return null != this.getAllExtensionsAsHash().remove(o);
    }

    public OXResourceExtensionInterface getExtensionbyName(String extname) {
        for (OXCommonExtension ext : this.getAllExtensionsAsHash().values()) {
            if (!extname.equals(ext.getClass().getName())) continue;
            return (OXResourceExtensionInterface)((Object)ext);
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String[] getMandatoryMembersChange() {
        return null;
    }

    @Override
    public String[] getMandatoryMembersCreate() {
        return new String[]{"name", "displayname", "email"};
    }

    @Override
    public String[] getMandatoryMembersDelete() {
        return null;
    }

    @Override
    public String[] getMandatoryMembersRegister() {
        return null;
    }

    public boolean isNameset() {
        return this.nameset;
    }

    public boolean isDisplaynameset() {
        return this.displaynameset;
    }

    public boolean isDescriptionset() {
        return this.descriptionset;
    }

    public boolean isEmailset() {
        return this.emailset;
    }

    public boolean isAvailableset() {
        return this.availableset;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.available == null ? 0 : this.available.hashCode());
        result = 31 * result + (this.availableset ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.descriptionset ? 1231 : 1237);
        result = 31 * result + (this.displayname == null ? 0 : this.displayname.hashCode());
        result = 31 * result + (this.displaynameset ? 1231 : 1237);
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.emailset ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameset ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
            return false;
        }
        if (this.availableset != other.availableset) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.descriptionset != other.descriptionset) {
            return false;
        }
        if (this.displayname == null ? other.displayname != null : !this.displayname.equals(other.displayname)) {
            return false;
        }
        if (this.displaynameset != other.displaynameset) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.emailset != other.emailset) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.nameset == other.nameset;
    }
}

