/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.rmi.dataobjects;

import com.openexchange.admin.rmi.dataobjects.ExtendableDataObject;
import com.openexchange.admin.rmi.dataobjects.NameAndIdObject;
import com.openexchange.admin.rmi.extensions.OXCommonExtension;
import com.openexchange.admin.rmi.extensions.OXGroupExtensionInterface;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends ExtendableDataObject
implements NameAndIdObject {
    private static final long serialVersionUID = -916912847701699619L;
    private Integer id;
    private String name;
    private boolean nameset;
    private String displayname;
    private boolean displaynameset;
    private Integer[] members;
    private boolean membersset;

    public Group() {
        this.init();
    }

    public Group(Integer id) {
        this.init();
        this.id = id;
    }

    public Group(Integer id, String name, String displayname) {
        this.init();
        this.id = id;
        this.name = name;
        this.displayname = displayname;
    }

    private void init() {
        this.initExtendable();
        this.id = null;
        this.name = null;
        this.displayname = null;
        this.members = null;
    }

    public final boolean isDisplaynameset() {
        return this.displaynameset;
    }

    public final boolean isMembersset() {
        return this.membersset;
    }

    public final boolean isNameset() {
        return this.nameset;
    }

    @Override
    public final Integer getId() {
        return this.id;
    }

    @Override
    public final void setId(Integer val) {
        this.id = val;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String val) {
        this.nameset = true;
        this.name = val;
    }

    public final String getDisplayname() {
        return this.displayname;
    }

    public final void setDisplayname(String displayname) {
        this.displaynameset = true;
        this.displayname = displayname;
    }

    public final Integer[] getMembers() {
        return this.members;
    }

    public final void setMembers(Integer[] members) {
        this.membersset = true;
        this.members = members;
    }

    @Override
    public final String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[ \n");
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                Object ob = f.get(this);
                String tname = f.getName();
                if (ob == null || tname.equals("serialVersionUID")) continue;
                ret.append("  ");
                ret.append(tname);
                ret.append(": ");
                ret.append(ob);
                ret.append("\n");
            }
            catch (IllegalArgumentException e) {
                ret.append("IllegalArgument\n");
            }
            catch (IllegalAccessException e) {
                ret.append("IllegalAccessException\n");
            }
        }
        ret.append("]");
        return ret.toString();
    }

    public final void addExtension(OXGroupExtensionInterface extension) {
        this.getAllExtensionsAsHash().put(extension.getClass().getName(), (OXCommonExtension)((Object)extension));
    }

    public final ArrayList<OXGroupExtensionInterface> getExtensions() {
        ArrayList<OXGroupExtensionInterface> retval = new ArrayList<OXGroupExtensionInterface>();
        for (OXCommonExtension commoninterface : this.getAllExtensionsAsHash().values()) {
            retval.add((OXGroupExtensionInterface)((Object)commoninterface));
        }
        return retval;
    }

    public final boolean removeExtension(OXGroupExtensionInterface o) {
        return null != this.getAllExtensionsAsHash().remove(o);
    }

    public final OXGroupExtensionInterface getExtensionbyName(String extname) {
        for (OXCommonExtension ext : this.getAllExtensionsAsHash().values()) {
            if (!extname.equals(ext.getClass().getName())) continue;
            return (OXGroupExtensionInterface)((Object)ext);
        }
        return null;
    }

    @Override
    public final String[] getMandatoryMembersCreate() {
        return new String[]{"displayname", "name"};
    }

    @Override
    public final String[] getMandatoryMembersChange() {
        return null;
    }

    @Override
    public final String[] getMandatoryMembersDelete() {
        return null;
    }

    @Override
    public final String[] getMandatoryMembersRegister() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.displayname == null ? 0 : this.displayname.hashCode());
        result = 31 * result + (this.displaynameset ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.members);
        result = 31 * result + (this.membersset ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameset ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.displayname == null ? other.displayname != null : !this.displayname.equals(other.displayname)) {
            return false;
        }
        if (this.displaynameset != other.displaynameset) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.members, (Object[])other.members)) {
            return false;
        }
        if (this.membersset != other.membersset) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.nameset == other.nameset;
    }
}

