/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.user;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.user.UserAbstraction;
import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserModuleAccess;
import com.openexchange.admin.rmi.exceptions.DatabaseUpdateException;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.NoSuchUserException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCore
extends UserAbstraction {
    private static final Object USER_ATTRIBUTES = "UserAttributes";

    protected final void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptions(parser);
        this.setCSVOutputOption(parser);
        this.searchOption = this.setShortLongOpt(parser, 's', "searchpattern", "The search pattern which is used for listing. This applies to name.", true, AdminParser.NeededQuadState.notneeded);
        this.setFurtherOptions(parser);
    }

    protected abstract void setFurtherOptions(AdminParser var1);

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        try {
            parser.ownparse(args);
            Context ctx = this.contextparsing(parser);
            Credentials auth = this.credentialsparsing(parser);
            OXUserInterface oxusr = this.getUserInterface();
            String pattern = (String)parser.getOptionValue(this.searchOption);
            if (null == pattern) {
                pattern = "*";
            }
            User[] allusers = this.maincall(parser, oxusr, pattern, ctx, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                HashMap<Integer, UserModuleAccess> usr2axs = new HashMap<Integer, UserModuleAccess>();
                for (User user : allusers) {
                    usr2axs.put(user.getId(), oxusr.getModuleAccess(ctx, user, auth));
                }
                this.precsvinfos(allusers, usr2axs);
            } else {
                this.sysoutOutput(allusers);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
        }
    }

    protected abstract User[] maincall(AdminParser var1, OXUserInterface var2, String var3, Context var4, Credentials var5) throws RemoteException, StorageException, InvalidCredentialsException, NoSuchContextException, InvalidDataException, DatabaseUpdateException, NoSuchUserException, DuplicateExtensionException;

    protected final String datetostring(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(COMMANDLINE_DATEFORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(COMMANDLINE_TIMEZONE));
        return null == date ? null : sdf.format(date);
    }

    protected final String booleantostring(Boolean boolean1) {
        return null == boolean1 ? null : boolean1.toString();
    }

    protected final String hashtostring(HashSet<?> set) {
        if (null != set && set.size() > 0) {
            String[] hashvalues = set.toArray(new String[set.size()]);
            StringBuilder sb = new StringBuilder();
            for (String value : hashvalues) {
                sb.append(value);
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    protected final String maptostring(Map<?, ?> map) {
        if (null != map && map.size() > 0) {
            HashMap hashMap = (HashMap)map;
            Iterator i = hashMap.entrySet().iterator();
            StringBuilder sb = new StringBuilder();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                sb.append((String)e.getKey());
                sb.append("=");
                sb.append((String)e.getValue());
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    protected final void sysoutOutput(User[] users) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (User user : users) {
            this.printExtensionsError(user);
            data.add(this.makeStandardData(user));
        }
        this.doOutput(new String[]{"r", "l", "l", "l"}, new String[]{"Id", "Name", "Displayname", "Email"}, data);
    }

    private ArrayList<String> makeStandardData(User user) {
        ArrayList<String> res_data = new ArrayList<String>();
        res_data.add(String.valueOf(user.getId()));
        String name = user.getName();
        if (name != null && name.trim().length() > 0) {
            res_data.add(name);
        } else {
            res_data.add(null);
        }
        String displayname = user.getDisplay_name();
        if (displayname != null && displayname.trim().length() > 0) {
            res_data.add(displayname);
        } else {
            res_data.add(null);
        }
        String email = user.getPrimaryEmail();
        if (email != null && email.trim().length() > 0) {
            res_data.add(email);
        } else {
            res_data.add(null);
        }
        return res_data;
    }

    protected final String timezonetostring(TimeZone zone) {
        return zone.getID();
    }

    private void precsvinfos(User[] users, HashMap<Integer, UserModuleAccess> access_map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InvalidDataException {
        Method[] methods = User.class.getMethods();
        HashMap<String, String> notallowedOrReplace = new HashMap<String, String>();
        notallowedOrReplace.put("GUI_Spam_filter_capabilities_enabled", "");
        notallowedOrReplace.put("Spam_filter_enabled", "");
        notallowedOrReplace.put("Gui_spam_filter_enabled", "GUI_Spam_filter_capabilities_enabled");
        ArrayList<UserAbstraction.MethodAndNames> methArrayList = this.getGetters(methods, notallowedOrReplace);
        ArrayList<String> columnnames = new ArrayList<String>(32);
        for (UserAbstraction.MethodAndNames methodandnames : methArrayList) {
            columnnames.add(methodandnames.getName());
        }
        if (users.length > 0) {
            columnnames.addAll(this.getColumnsOfAllExtensions(users[0]));
            columnnames.add("access-calendar");
            columnnames.add("access-contacts");
            columnnames.add("access-delegate-tasks");
            columnnames.add("access-edit-public-folder");
            columnnames.add("access-forum");
            columnnames.add("access-ical");
            columnnames.add("access-infostore");
            columnnames.add("access-pinboard-write");
            columnnames.add("access-projects");
            columnnames.add("access-read-create-shared-Folders");
            columnnames.add("access-rss-bookmarks");
            columnnames.add("access-rss-portal");
            columnnames.add("access-syncml");
            columnnames.add("access-tasks");
            columnnames.add("access-vcard");
            columnnames.add("access-webdav");
            columnnames.add("access-webdav-xml");
            columnnames.add("access-webmail");
            columnnames.add("access-edit-group");
            columnnames.add("access-edit-resource");
            columnnames.add("access-edit-password");
            columnnames.add("access-collect-email-addresses");
            columnnames.add("access-multiple-mail-accounts");
            columnnames.add("access-subscription");
            columnnames.add("access-publication");
            columnnames.add("access-active-sync");
            columnnames.add("access-usm");
            columnnames.add("access-global-address-book-disabled");
            columnnames.add("access-public-folder-editable");
        }
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (User user : users) {
            ArrayList<String> datarow = new ArrayList<String>();
            for (UserAbstraction.MethodAndNames methodandnames : methArrayList) {
                String returntype = methodandnames.getReturntype();
                if (returntype.equals("java.lang.String")) {
                    datarow.add((String)methodandnames.getMethod().invoke((Object)user, (Object[])null));
                    continue;
                }
                if (returntype.equals("java.lang.Integer")) {
                    datarow.add(String.valueOf(methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.lang.Boolean")) {
                    datarow.add(this.booleantostring((Boolean)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.util.Date")) {
                    datarow.add(this.datetostring((Date)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.util.HashSet")) {
                    datarow.add(this.hashtostring((HashSet)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.util.Map")) {
                    if (methodandnames.getName().equals(USER_ATTRIBUTES)) {
                        datarow.add(this.userattributestostring((Map)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                        continue;
                    }
                    datarow.add(this.maptostring((HashMap)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.util.TimeZone")) {
                    datarow.add(this.timezonetostring((TimeZone)methodandnames.getMethod().invoke((Object)user, (Object[])null)));
                    continue;
                }
                if (returntype.equals("java.util.Locale")) {
                    datarow.add(((Locale)methodandnames.getMethod().invoke((Object)user, (Object[])null)).toString());
                    continue;
                }
                if (!returntype.equals("int")) continue;
                datarow.add(((Integer)methodandnames.getMethod().invoke((Object)user, (Object[])null)).toString());
            }
            datarow.addAll(this.getDataOfAllExtensions(user));
            UserModuleAccess access = access_map.get(user.getId());
            datarow.add(String.valueOf(access.getCalendar()));
            datarow.add(String.valueOf(access.getContacts()));
            datarow.add(String.valueOf(access.getDelegateTask()));
            datarow.add(String.valueOf(access.getEditPublicFolders()));
            datarow.add(String.valueOf(access.getForum()));
            datarow.add(String.valueOf(access.getIcal()));
            datarow.add(String.valueOf(access.getInfostore()));
            datarow.add(String.valueOf(access.getPinboardWrite()));
            datarow.add(String.valueOf(access.getProjects()));
            datarow.add(String.valueOf(access.getReadCreateSharedFolders()));
            datarow.add(String.valueOf(access.getRssBookmarks()));
            datarow.add(String.valueOf(access.getRssPortal()));
            datarow.add(String.valueOf(access.getSyncml()));
            datarow.add(String.valueOf(access.getTasks()));
            datarow.add(String.valueOf(access.getVcard()));
            datarow.add(String.valueOf(access.getWebdav()));
            datarow.add(String.valueOf(access.getWebdavXml()));
            datarow.add(String.valueOf(access.getWebmail()));
            datarow.add(String.valueOf(access.getEditGroup()));
            datarow.add(String.valueOf(access.getEditResource()));
            datarow.add(String.valueOf(access.getEditPassword()));
            datarow.add(String.valueOf(access.isCollectEmailAddresses()));
            datarow.add(String.valueOf(access.isMultipleMailAccounts()));
            datarow.add(String.valueOf(access.isSubscription()));
            datarow.add(String.valueOf(access.isPublication()));
            datarow.add(String.valueOf(access.isActiveSync()));
            datarow.add(String.valueOf(access.isUSM()));
            datarow.add(String.valueOf(access.isGlobalAddressBookDisabled()));
            datarow.add(String.valueOf(access.isPublicFolderEditable()));
            data.add(datarow);
            this.printExtensionsError(user);
        }
        this.doCSVOutput(columnnames, data);
    }

    private String userattributestostring(Map<String, Map<String, String>> dynamicAttributes) {
        if (dynamicAttributes.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(128);
        for (Map.Entry<String, Map<String, String>> namespaced : dynamicAttributes.entrySet()) {
            builder.append(namespaced.getKey()).append("=[").append(this.maptostring(namespaced.getValue())).append("],");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    protected abstract ArrayList<String> getDataOfAllExtensions(User var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    protected abstract ArrayList<String> getColumnsOfAllExtensions(User var1);

    @Override
    protected final String getObjectName() {
        return "users";
    }
}

