/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.user;

import au.com.bytecode.opencsv.CSVReader;
import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.user.UserAbstraction;
import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserModuleAccess;
import com.openexchange.admin.rmi.exceptions.DatabaseUpdateException;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.ParseException;

public abstract class CreateCore
extends UserAbstraction {
    protected final void setOptions(AdminParser parser) {
        parser.setExtendedOptions();
        this.setCsvImport(parser);
        this.setDefaultCommandLineOptions(parser);
        this.setMandatoryOptions(parser);
        this.setOptionalOptions(parser);
        this.setFurtherOptions(parser);
        parser.allowDynamicOptions();
    }

    protected abstract void setFurtherOptions(AdminParser var1);

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        this.setExtendedOptions(parser);
        try {
            parser.ownparse(args);
            Context ctx = this.contextparsing(parser);
            this.ctxid = ctx.getId();
            Credentials auth = this.credentialsparsing(parser);
            OXUserInterface oxusr = this.getUserInterface();
            User usr = new User();
            this.parseAndSetMandatoryOptionsinUser(parser, usr);
            this.parseAndSetOptionalOptionsinUser(parser, usr);
            this.applyExtendedOptionsToUser(parser, usr);
            this.applyDynamicOptionsToUser(parser, usr);
            String filename = (String)parser.getOptionValue(parser.getCsvImportOption());
            if (null != filename) {
                this.csvParsing(filename, oxusr);
            } else {
                this.applyExtendedOptionsToUser(parser, usr);
                this.maincall(parser, oxusr, ctx, usr, auth);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
        }
    }

    protected abstract void maincall(AdminParser var1, OXUserInterface var2, Context var3, User var4, Credentials var5) throws RemoteException, StorageException, InvalidCredentialsException, NoSuchContextException, InvalidDataException, DatabaseUpdateException, DuplicateExtensionException, MalformedURLException, NotBoundException, ConnectException;

    private void csvParsing(String filename, OXUserInterface oxuser) throws FileNotFoundException, IOException, InvalidDataException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new FileReader(filename), ',', '\"');
        int[] idarray = this.csvParsingCommon(filename, reader);
        int linenumber = 2;
        while ((nextLine = reader.readNext()) != null) {
            try {
                Context context = this.getContext(nextLine, idarray);
                try {
                    User adminuser = CreateCore.getUser(nextLine, idarray);
                    Credentials auth = CreateCore.getCreds(nextLine, idarray);
                    int i = idarray[UserAbstraction.AccessCombinations.ACCESS_COMBI_NAME.getIndex()];
                    try {
                        UserModuleAccess moduleacess;
                        User create = -1 != i ? oxuser.create(context, adminuser, nextLine[i], auth) : (!NO_RIGHTS_ACCESS.equals(moduleacess = CreateCore.getUserModuleAccess(nextLine, idarray)) ? oxuser.create(context, adminuser, moduleacess, auth) : oxuser.create(context, adminuser, auth));
                        System.out.println("User " + create.getId() + " successfully created in context " + context.getId());
                    }
                    catch (RemoteException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                    catch (StorageException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                    catch (InvalidCredentialsException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                    catch (NoSuchContextException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                    catch (InvalidDataException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                    catch (DatabaseUpdateException e) {
                        System.err.println("Failed to create user \"" + adminuser.getName() + "\" in context " + context.getId() + ": " + e);
                    }
                }
                catch (ParseException e1) {
                    System.err.println("Failed to create user in context " + context.getId() + ": " + e1);
                }
            }
            catch (ParseException e1) {
                System.err.println("Failed to create user in context in line" + linenumber + ": " + e1);
            }
            ++linenumber;
        }
    }
}

