/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.resource;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.resource.ResourceAbstraction;
import com.openexchange.admin.rmi.OXResourceInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Resource;
import com.openexchange.admin.rmi.exceptions.DatabaseUpdateException;
import com.openexchange.admin.rmi.exceptions.DuplicateExtensionException;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.NoSuchResourceException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.rmi.RemoteException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCore
extends ResourceAbstraction {
    protected final void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptions(parser);
        this.setCSVOutputOption(parser);
        this.searchOption = this.setShortLongOpt(parser, 's', "searchpattern", "The search pattern which is used for listing. This applies to name.", true, AdminParser.NeededQuadState.notneeded);
    }

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        try {
            parser.ownparse(args);
            Context ctx = this.contextparsing(parser);
            Credentials auth = this.credentialsparsing(parser);
            String pattern = (String)parser.getOptionValue(this.searchOption);
            if (null == pattern) {
                pattern = "*";
            }
            OXResourceInterface oxres = this.getResourceInterface();
            Resource[] allres = oxres.list(ctx, pattern, auth);
            ArrayList<Resource> resourceList = new ArrayList<Resource>();
            this.maincall(parser, oxres, ctx, resourceList, allres, auth);
            if (parser.getOptionValue(this.csvOutputOption) != null) {
                this.precsvinfos(resourceList);
            } else {
                this.sysoutOutput(resourceList);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
        }
    }

    protected final void sysoutOutput(ArrayList<Resource> resources) throws InvalidDataException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Resource resource : resources) {
            this.printExtensionsError(resource);
            data.add(this.makeStandardData(resource));
        }
        this.doOutput(new String[]{"r", "l", "l", "l", "l"}, new String[]{"Id", "Name", "Displayname", "Email", "Available"}, data);
    }

    protected abstract void maincall(AdminParser var1, OXResourceInterface var2, Context var3, ArrayList<Resource> var4, Resource[] var5, Credentials var6) throws RemoteException, StorageException, InvalidCredentialsException, NoSuchContextException, InvalidDataException, DatabaseUpdateException, NoSuchResourceException, DuplicateExtensionException;

    private void precsvinfos(ArrayList<Resource> resourceList) throws InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("name");
        columns.add("displayname");
        columns.add("email");
        columns.add("available");
        columns.add("description");
        this.extendscvscolumns(columns);
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Resource my_res : resourceList) {
            ArrayList<String> makeCsvData = this.makeCsvData(my_res);
            makeCsvData.add(my_res.getDescription());
            data.add(makeCsvData);
            this.printExtensionsError(my_res);
        }
        this.doCSVOutput(columns, data);
    }

    protected abstract void extendscvscolumns(ArrayList<String> var1);

    private ArrayList<String> makeCsvData(Resource my_res) {
        ArrayList<String> res_data = this.makeStandardData(my_res);
        this.extendmakeCSVData(my_res, res_data);
        return res_data;
    }

    private ArrayList<String> makeStandardData(Resource my_res) {
        ArrayList<String> res_data = new ArrayList<String>();
        res_data.add(String.valueOf(my_res.getId()));
        String name = my_res.getName();
        if (name != null && name.trim().length() > 0) {
            res_data.add(name);
        } else {
            res_data.add(null);
        }
        String displayname = my_res.getDisplayname();
        if (displayname != null && displayname.trim().length() > 0) {
            res_data.add(displayname);
        } else {
            res_data.add(null);
        }
        String email = my_res.getEmail();
        if (email != null && email.trim().length() > 0) {
            res_data.add(email);
        } else {
            res_data.add(null);
        }
        Boolean available = my_res.getAvailable();
        if (available != null) {
            res_data.add(available.toString());
        } else {
            res_data.add(null);
        }
        return res_data;
    }

    protected abstract void extendmakeCSVData(Resource var1, ArrayList<String> var2);

    @Override
    protected final String getObjectName() {
        return "resources";
    }
}

