/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.ServiceLoader;
import com.openexchange.admin.console.context.ContextAbstraction;
import com.openexchange.admin.console.context.extensioninterfaces.ContextConsoleListInterface;
import com.openexchange.admin.plugins.PluginException;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.exceptions.InvalidCredentialsException;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import com.openexchange.admin.rmi.exceptions.NoSuchContextException;
import com.openexchange.admin.rmi.exceptions.StorageException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCore
extends ContextAbstraction {
    private ServiceLoader<ContextConsoleListInterface> listsubclasses = null;

    protected void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setCSVOutputOption(parser);
        this.setFurtherOptions(parser);
    }

    protected abstract void setFurtherOptions(AdminParser var1);

    protected final void commonfunctions(AdminParser parser, String[] args) {
        this.setOptions(parser);
        this.setExtensionOptions(parser, ContextConsoleListInterface.class);
        Context[] ctxs = null;
        try {
            Credentials auth = null;
            String pattern = null;
            try {
                parser.ownparse(args);
                auth = this.credentialsparsing(parser);
                pattern = this.getSearchPattern(parser);
                this.parseAndSetExtensions(parser, null, auth);
            }
            catch (RuntimeException e) {
                this.printError(null, null, e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
            ctxs = this.maincall(parser, pattern, auth);
        }
        catch (Exception e) {
            this.printErrors(null, null, e, parser);
        }
        try {
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(ctxs, parser);
            } else {
                this.sysoutOutput(ctxs, parser);
            }
        }
        catch (InvalidDataException e) {
            this.printError(null, null, "Invalid data : " + e.getMessage(), parser);
            this.sysexit(1);
        }
        catch (RuntimeException e) {
            this.printError(null, null, e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
            this.sysexit(1);
        }
        this.sysexit(0);
    }

    protected abstract String getSearchPattern(AdminParser var1);

    protected abstract Context[] maincall(AdminParser var1, String var2, Credentials var3) throws RemoteException, StorageException, InvalidCredentialsException, InvalidDataException, MalformedURLException, NotBoundException, NoSuchContextException;

    @Override
    protected final String getObjectName() {
        return "contexts";
    }

    @Override
    protected ArrayList<String> getCSVDataOfAllExtensions(final Context ctx, AdminParser parser) {
        return this.abstractGetter(parser, new GetterClosureInterface(){

            @Override
            public ArrayList<String> getData(ContextConsoleListInterface commonex) throws PluginException {
                return commonex.getCSVData(ctx);
            }
        });
    }

    @Override
    protected ArrayList<String> getHumanReableDataOfAllExtensions(final Context ctx, AdminParser parser) {
        return this.abstractGetter(parser, new GetterClosureInterface(){

            @Override
            public ArrayList<String> getData(ContextConsoleListInterface commonex) throws PluginException {
                return commonex.getHumanReadableData(ctx);
            }
        });
    }

    protected ArrayList<String> getCSVColumnsOfAllExtensions(AdminParser parser) {
        return this.abstractGetter(parser, new GetterClosureInterface(){

            @Override
            public ArrayList<String> getData(ContextConsoleListInterface commonex) {
                return commonex.getColumnNamesCSV();
            }
        });
    }

    @Override
    protected ArrayList<String> getHumanReadableColumnsOfAllExtensions(AdminParser parser) {
        return this.abstractGetter(parser, new GetterClosureInterface(){

            @Override
            public ArrayList<String> getData(ContextConsoleListInterface commonex) {
                return commonex.getColumnNamesHumanReadable();
            }
        });
    }

    private ArrayList<String> abstractGetter(AdminParser parser, GetterClosureInterface iface) {
        ArrayList<String> retval = new ArrayList<String>();
        if (null == this.listsubclasses) {
            try {
                this.listsubclasses = ServiceLoader.load(ContextConsoleListInterface.class);
            }
            catch (IllegalAccessException e) {
                this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
            catch (InstantiationException e) {
                this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
            catch (ClassNotFoundException e) {
                this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
            catch (IOException e) {
                this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
        }
        for (ContextConsoleListInterface commoniface : this.listsubclasses) {
            try {
                retval.addAll(iface.getData(commoniface));
            }
            catch (PluginException e) {
                this.printError(null, null, "Error during initializing extensions: " + e.getClass().getSimpleName() + ": " + e.getMessage(), parser);
                this.sysexit(1);
            }
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface GetterClosureInterface {
        public ArrayList<String> getData(ContextConsoleListInterface var1) throws PluginException;
    }
}

