/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader<S>
implements Iterable<S> {
    private List<S> list = null;

    private ServiceLoader(List<S> list) {
        this.list = list;
    }

    public static <S> ServiceLoader<S> load(Class<S> service) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) throws IllegalAccessException, InstantiationException, ClassNotFoundException, IOException {
        ArrayList<S> retval = new ArrayList<S>();
        Enumeration<URL> resources = loader.getResources("META-INF/services/" + service.getName());
        while (resources.hasMoreElements()) {
            URL nextElement = resources.nextElement();
            BufferedReader stringReader = new BufferedReader(new InputStreamReader(nextElement.openStream(), "UTF-8"));
            try {
                String readLine = stringReader.readLine();
                Class<?> forName = Class.forName(readLine);
                if (!service.isAssignableFrom(forName)) {
                    System.err.println("The class given in the META-INF/services directory is no subclass of ContextConsoleInterface");
                    break;
                }
                Class<S> asSubclass = forName.asSubclass(service);
                retval.add(asSubclass.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            finally {
                stringReader.close();
            }
        }
        return new ServiceLoader(retval);
    }

    @Override
    public Iterator<S> iterator() {
        return this.list.iterator();
    }
}

