/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.CLIIllegalOptionValueException;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.CLIParseException;
import com.openexchange.admin.console.CLIUnknownOptionException;
import com.openexchange.admin.console.CLIUnknownSuboptionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIParser {
    private static final String OPT_START = "--";
    private final boolean posix;
    private String[] remainingArgs;
    private final Map<String, CLIOption> options;
    private final Map<String, List<Object>> values;
    private final Options cliOptions;

    public CLIParser() {
        this(false);
    }

    public CLIParser(boolean posix) {
        this.posix = posix;
        this.cliOptions = posix ? new Options() : null;
        this.options = new HashMap<String, CLIOption>(16);
        this.values = new HashMap<String, List<Object>>(16);
    }

    public CLIOption addOption(CLIOption opt) {
        String shortForm = opt.shortForm();
        StringBuilder sb = new StringBuilder(16);
        if (shortForm != null) {
            this.options.put(sb.append('-').append(shortForm).toString(), opt);
            sb.setLength(0);
        }
        String longForm = opt.longForm();
        this.options.put(sb.append(OPT_START).append(longForm).toString(), opt);
        if (this.posix) {
            this.cliOptions.addOption(shortForm == null ? " " : shortForm, longForm, opt.wantsValue(), "");
        }
        return opt;
    }

    public CLIOption addStringOption(char shortForm, String longForm) {
        return this.addOption(new CLIOption.CLIStringOption(shortForm, longForm));
    }

    public CLIOption addStringOption(String longForm) {
        return this.addOption(new CLIOption.CLIStringOption(longForm));
    }

    public CLIOption addSettableBooleanOption(String longForm) {
        return this.addOption(new CLIOption.CLISettableBooleanOption(longForm));
    }

    public CLIOption addIntegerOption(char shortForm, String longForm) {
        return this.addOption(new CLIOption.CLIIntegerOption(shortForm, longForm));
    }

    public CLIOption addIntegerOption(String longForm) {
        return this.addOption(new CLIOption.CLIIntegerOption(longForm));
    }

    public CLIOption addLongOption(char shortForm, String longForm) {
        return this.addOption(new CLIOption.CLILongOption(shortForm, longForm));
    }

    public CLIOption addLongOption(String longForm) {
        return this.addOption(new CLIOption.CLILongOption(longForm));
    }

    public CLIOption addDoubleOption(char shortForm, String longForm) {
        return this.addOption(new CLIOption.CLIDoubleOption(shortForm, longForm));
    }

    public CLIOption addDoubleOption(String longForm) {
        return this.addOption(new CLIOption.CLIDoubleOption(longForm));
    }

    public CLIOption addBooleanOption(char shortForm, String longForm) {
        return this.addOption(new CLIOption.CLIBooleanOption(shortForm, longForm));
    }

    public CLIOption addBooleanOption(String longForm) {
        return this.addOption(new CLIOption.CLIBooleanOption(longForm));
    }

    public Object getOptionValue(CLIOption o) {
        return this.getOptionValue(o, null, false);
    }

    public Object getOptionValue(CLIOption o, Object def, boolean remove) {
        List<Object> vals = this.values.get(o.longForm());
        if (null == vals) {
            return def;
        }
        if (vals.isEmpty()) {
            return null;
        }
        return remove ? vals.remove(0) : vals.get(0);
    }

    public final Collection<Object> getOptionValues(CLIOption option) {
        ArrayList<Object> result = new ArrayList<Object>(2);
        Object o;
        while ((o = this.getOptionValue(option, null, true)) != null) {
            result.add(o);
        }
        return result;
    }

    public String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    protected final void removeOption(CLIOption option) {
        String shortForm = option.shortForm();
        StringBuilder sb = new StringBuilder(16);
        if (null != shortForm) {
            this.options.remove(sb.append('-').append(shortForm).toString());
            sb.setLength(0);
        }
        this.options.remove(sb.append(OPT_START).append(option.longForm()).toString());
    }

    public void parse(String[] argv) throws CLIParseException, CLIIllegalOptionValueException, CLIUnknownOptionException {
        this.parse(argv, Locale.getDefault());
    }

    public void parse(String[] argv, Locale locale) throws CLIParseException, CLIIllegalOptionValueException, CLIUnknownOptionException {
        if (!this.posix) {
            this.manualParse(argv, locale);
            return;
        }
        try {
            CommandLine cliCommandLine = new PosixParser().parse(this.cliOptions, argv);
            LongOptionProvider lp = null;
            ShortOptionProvider sp = null;
            StringBuilder sb = new StringBuilder(16).append(OPT_START);
            for (Option parsedOption : cliCommandLine) {
                String parsedLongOpt = parsedOption.getLongOpt();
                CLIOption opt = this.options.get(sb.append(parsedLongOpt).toString());
                if (null == opt) {
                    throw new CLIUnknownOptionException(parsedLongOpt);
                }
                sb.setLength(2);
                String shortForm = opt.shortForm();
                if (null == shortForm) {
                    if (null == lp) {
                        lp = new LongOptionProvider(opt.longForm(), cliCommandLine);
                    } else {
                        lp.set(opt.longForm());
                    }
                    this.handleOption(opt, shortForm, locale, lp);
                    continue;
                }
                if (null == sp) {
                    sp = new ShortOptionProvider(shortForm.charAt(0), cliCommandLine);
                } else {
                    sp.set(shortForm.charAt(0));
                }
                this.handleOption(opt, shortForm, locale, sp);
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CLIUnknownOptionException(CLIParser.extractOption(e.getMessage()), e);
        }
        catch (MissingArgumentException e) {
            String optName = CLIParser.extractOption(e.getMessage());
            throw new CLIUnknownOptionException(optName, new StringBuilder(32).append("Missing argument for option '").append(optName).append('\'').toString(), e);
        }
        catch (ParseException e) {
            throw new CLIParseException(argv, (Throwable)e);
        }
    }

    private static String extractOption(String msg) {
        if (null == msg) {
            return null;
        }
        int pos = msg.indexOf(58);
        if (pos >= 0) {
            return msg.substring(pos + 1);
        }
        return msg;
    }

    private void handleOption(CLIOption opt, String shortForm, Locale locale, OptionProvider provider) throws CLIIllegalOptionValueException {
        if (provider.hasOption()) {
            String val = provider.getValue();
            String longForm = opt.longForm();
            List<Object> vals = this.values.get(longForm);
            if (null == vals) {
                vals = new ArrayList<Object>(2);
                this.values.put(longForm, vals);
                if (null != shortForm) {
                    this.values.put(shortForm, vals);
                }
            }
            vals.add(opt.parseValue(val, locale));
        } else if (opt.wantsValue()) {
            throw new CLIIllegalOptionValueException(opt, "");
        }
    }

    private final void manualParse(String[] args, Locale locale) throws CLIIllegalOptionValueException, CLIUnknownOptionException {
        ArrayList<String> otherArgs = new ArrayList<String>(2);
        int position = 0;
        while (position < args.length) {
            String argument = args[position];
            int len = argument.length();
            if (len > 0 && '-' == argument.charAt(0)) {
                if (OPT_START.equals(argument)) {
                    ++position;
                    break;
                }
                if (len > 1 && '-' == argument.charAt(1)) {
                    int pos = argument.indexOf(61);
                    if (-1 == pos) {
                        position = this.lookUpOption(argument, null, args, locale, position);
                        continue;
                    }
                    position = this.lookUpOption(argument.substring(0, pos), argument.substring(pos + 1), args, locale, position);
                    continue;
                }
                if (len > 2) {
                    StringBuilder sb = new StringBuilder(2).append('-');
                    for (int i = 1; i < len; ++i) {
                        char c = argument.charAt(i);
                        CLIOption opt = this.options.get(sb.append(c).toString());
                        if (opt == null) {
                            throw new CLIUnknownSuboptionException(argument, c);
                        }
                        if (opt.wantsValue()) {
                            throw new CLIUnknownOptionException(argument, new StringBuilder(32).append("Missing argument for option '").append(argument).append('\'').toString());
                        }
                        sb.setLength(1);
                        this.addValue(opt, opt.parseValue(null, locale));
                    }
                    ++position;
                    continue;
                }
                position = this.lookUpOption(argument, null, args, locale, position);
                continue;
            }
            otherArgs.add(argument);
            ++position;
        }
        while (position < args.length) {
            otherArgs.add(args[position]);
            ++position;
        }
        this.remainingArgs = otherArgs.toArray(new String[otherArgs.size()]);
    }

    private int lookUpOption(String argument, String valueArg, String[] args, Locale locale, int position) throws CLIIllegalOptionValueException, CLIUnknownOptionException {
        Object value;
        CLIOption opt = this.options.get(argument);
        if (null == opt) {
            throw new CLIUnknownOptionException(argument);
        }
        int pos = position;
        if (opt.wantsValue()) {
            String val = valueArg;
            if (null == val && ++pos < args.length) {
                val = args[pos];
            }
            value = opt.parseValue(val, locale);
        } else {
            value = opt.parseValue(null, locale);
        }
        this.addValue(opt, value);
        return ++pos;
    }

    private void addValue(CLIOption opt, Object value) {
        String longForm = opt.longForm();
        List<Object> vals = this.values.get(longForm);
        if (null == vals) {
            vals = new ArrayList<Object>(2);
            this.values.put(longForm, vals);
            String shortForm = opt.shortForm();
            if (null != shortForm) {
                this.values.put(shortForm, vals);
            }
        }
        vals.add(value);
    }

    private static final class LongOptionProvider
    implements OptionProvider {
        private final CommandLine cliCommandLine;
        private String s;

        LongOptionProvider(String s, CommandLine cliCommandLine) {
            this.s = s;
            this.cliCommandLine = cliCommandLine;
        }

        void set(String s) {
            this.s = s;
        }

        public String getValue() {
            return this.cliCommandLine.getOptionValue(this.s);
        }

        public boolean hasOption() {
            return this.cliCommandLine.hasOption(this.s);
        }
    }

    private static final class ShortOptionProvider
    implements OptionProvider {
        private final CommandLine cliCommandLine;
        private char c;

        ShortOptionProvider(char c, CommandLine cliCommandLine) {
            this.c = c;
            this.cliCommandLine = cliCommandLine;
        }

        void set(char c) {
            this.c = c;
        }

        public String getValue() {
            return this.cliCommandLine.getOptionValue(this.c);
        }

        public boolean hasOption() {
            return this.cliCommandLine.hasOption(this.c);
        }
    }

    private static interface OptionProvider {
        public boolean hasOption();

        public String getValue();
    }
}

