/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.BasicCommandlineOptions;
import com.openexchange.admin.console.CLIIllegalOptionValueException;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.CLIParseException;
import com.openexchange.admin.console.CLIParser;
import com.openexchange.admin.console.CLIUnknownOptionException;
import com.openexchange.admin.rmi.exceptions.MissingOptionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminParser
extends CLIParser {
    private static final String OPT_HELP_LONG = "help";
    private static final char OPT_HELP_SHORT = 'h';
    private static final String OPT_CHECK_UNIQUENESS = "check";
    private static final String OPT_ENVOPTS_LONG = "environment";
    private static final String OPT_EXTENDED_LONG = "extendedoptions";
    private static final String OPT_NAME_NONEWLINE_LONG = "nonl";
    private static final String OPT_NAME_NONEWLINE_DESCRIPTION = "Remove all newlines (\\n) from output";
    private final ArrayList<OptionInfo> optinfolist = new ArrayList();
    private String appname = null;
    private CLIOption csvImportOption = null;
    private final CLIOption helpoption;
    private final CLIOption envoption;
    private final CLIOption checkuniquenessoption;
    private CLIOption extendedoption;
    private final CLIOption noNewlineOption;
    private boolean allowDynamic;
    private Map<String, Map<String, String>> dynamicMaps = new HashMap<String, Map<String, String>>();

    public AdminParser(String appname) {
        this.appname = appname;
        this.helpoption = this.addOption('h', OPT_HELP_LONG, null, "Prints a help text", NeededQuadState.notneeded, false);
        this.envoption = this.addOption(OPT_ENVOPTS_LONG, "Output this help text", "Show info about commandline environment", false, false);
        this.checkuniquenessoption = this.addOption(OPT_CHECK_UNIQUENESS, "Checks if short parameters are unique", false, false, true);
        this.noNewlineOption = this.addOption(OPT_NAME_NONEWLINE_LONG, OPT_NAME_NONEWLINE_DESCRIPTION, false, false, false);
    }

    public final CLIOption addOption(char shortForm, String longForm, String description, boolean needed) {
        CLIOption retval = this.addStringOption(shortForm, longForm);
        this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, shortForm, longForm, description));
        return retval;
    }

    public final CLIOption addOption(char shortForm, String longForm, String longFormParameterDescription, String description, boolean needed) {
        CLIOption retval = this.addStringOption(shortForm, longForm);
        this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, shortForm, longForm, longFormParameterDescription, description));
        return retval;
    }

    public final CLIOption addOption(char shortForm, String longForm, String longFormParameterDescription, String description, NeededQuadState needed, boolean hasarg) {
        if (hasarg) {
            CLIOption retval = this.addStringOption(shortForm, longForm);
            this.optinfolist.add(new OptionInfo(needed, retval, shortForm, longForm, longFormParameterDescription, description));
            return retval;
        }
        CLIOption retval = this.addBooleanOption(shortForm, longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, shortForm, longForm, description));
        return retval;
    }

    public final CLIOption addOption(String longForm, String longFormParameterDescription, String description, boolean needed) {
        CLIOption retval = this.addStringOption(longForm);
        this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, longForm, longFormParameterDescription, description));
        return retval;
    }

    public final CLIOption addOption(String longForm, String longFormParameterDescription, String description, boolean needed, boolean hasarg) {
        if (hasarg) {
            CLIOption retval = this.addStringOption(longForm);
            this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, longForm, longFormParameterDescription, description));
            return retval;
        }
        CLIOption retval = this.addBooleanOption(longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, longForm, description));
        return retval;
    }

    public final CLIOption addOption(String longForm, String longFormParameterDescription, String description, boolean needed, boolean hasarg, boolean extended) {
        if (hasarg) {
            CLIOption retval = this.addStringOption(longForm);
            this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, longForm, longFormParameterDescription, description, extended));
            return retval;
        }
        CLIOption retval = this.addBooleanOption(longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, longForm, description, extended));
        return retval;
    }

    public final CLIOption addIntegerOption(String longForm, String longFormParameterDescription, String description, boolean needed, boolean hasarg, boolean extended) {
        if (hasarg) {
            CLIOption retval = this.addIntegerOption(longForm);
            this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, longForm, longFormParameterDescription, description, extended));
            return retval;
        }
        CLIOption retval = this.addBooleanOption(longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, longForm, description, extended));
        return retval;
    }

    private final CLIOption addOption(String longForm, String description, boolean needed, boolean extended, boolean hidden) {
        CLIOption retval = this.addBooleanOption(longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, longForm, description, extended, hidden));
        return retval;
    }

    public final CLIOption addSettableBooleanOption(String longForm, String longFormParameterDescription, String description, boolean needed, boolean hasarg, boolean extended) {
        if (hasarg) {
            CLIOption retval = this.addSettableBooleanOption(longForm);
            this.optinfolist.add(new OptionInfo(this.convertBooleantoTriState(needed), retval, longForm, longFormParameterDescription, description, extended));
            return retval;
        }
        CLIOption retval = this.addBooleanOption(longForm);
        this.optinfolist.add(new OptionInfo(NeededQuadState.notneeded, retval, longForm, description, extended));
        return retval;
    }

    public final boolean checkNoNewLine() {
        return null != this.getOptionValue(this.noNewlineOption);
    }

    public CLIOption getCsvImportOption() {
        return this.csvImportOption;
    }

    public final void ownparse(String[] args) throws CLIParseException, CLIIllegalOptionValueException, CLIUnknownOptionException, MissingOptionException {
        if (this.allowDynamic) {
            args = this.extractDynamic(args);
        }
        this.parse(args);
        if (null != this.getOptionValue(this.checkuniquenessoption)) {
            this.checkOptionUniqueness();
        }
        if (null != this.getOptionValue(this.helpoption)) {
            this.printUsage();
            System.exit(0);
        }
        if (null != this.getOptionValue(this.envoption)) {
            this.printEnvUsage();
            System.exit(0);
        }
        if (null != this.extendedoption && null != this.getOptionValue(this.extendedoption)) {
            this.printUsageExtended();
            System.exit(0);
        }
        if (null == this.csvImportOption || null == this.getOptionValue(this.csvImportOption)) {
            StringBuilder sb = new StringBuilder();
            for (OptionInfo optInfo : this.optinfolist) {
                if (optInfo.needed != NeededQuadState.needed || null != this.getOptionValue(optInfo.option)) continue;
                sb.append(optInfo.longForm);
                sb.append(",");
            }
            if (sb.toString().length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                throw new MissingOptionException("Option(s) \"" + sb.toString() + "\" missing");
            }
        }
    }

    private String[] extractDynamic(String[] args) {
        ArrayList<String> staticArgs = new ArrayList<String>(args.length);
        for (String arg : args) {
            if (this.isExtendedOption(arg) && this.isDynamicOption(arg)) {
                this.parseDynamicOption(arg);
                continue;
            }
            staticArgs.add(arg);
        }
        return staticArgs.toArray(new String[staticArgs.size()]);
    }

    private void parseDynamicOption(String arg) {
        int slashPos = arg.indexOf(47);
        int equalPos = arg.indexOf(61);
        if (slashPos == -1) {
            return;
        }
        if (equalPos == -1) {
            return;
        }
        String namespace = arg.substring(2, slashPos);
        String name = arg.substring(slashPos + 1, equalPos);
        String value = arg.substring(equalPos + 1);
        this.getDynamicMap(namespace).put(name, value);
    }

    private Map<String, String> getDynamicMap(String namespace) {
        Map<String, String> namespacedMap = this.dynamicMaps.get(namespace);
        if (namespacedMap == null) {
            namespacedMap = new HashMap<String, String>();
            this.dynamicMaps.put(namespace, namespacedMap);
        }
        return namespacedMap;
    }

    private boolean isDynamicOption(String arg) {
        int slashPos = arg.indexOf(47);
        if (slashPos == -1) {
            return false;
        }
        return slashPos < arg.indexOf(61);
    }

    private boolean isExtendedOption(String arg) {
        return arg.startsWith("--");
    }

    public void setCsvImportOption(CLIOption csvImportOption) {
        this.csvImportOption = csvImportOption;
    }

    public final void setExtendedOptions() {
        this.extendedoption = this.addOption(OPT_EXTENDED_LONG, OPT_EXTENDED_LONG, "Set this if you want to see all options, use this instead of help option", false, false);
    }

    public final void printEnvUsage() {
        System.out.println("\nThe following environment variables and their current value are known\nand can be modified to change behaviour:\n");
        Hashtable<String, String> env = BasicCommandlineOptions.getEnvOptions();
        for (String key : env.keySet()) {
            System.out.println("\t" + key + "=" + env.get(key));
        }
        System.out.println("\n");
        System.out.println("Date format is used to format all dates coming out of or going into the system.");
        System.out.println("\n");
        System.out.println("For possible date formats, see\n http://java.sun.com/j2se/1.5.0/docs/api/java/text/SimpleDateFormat.html");
        System.out.println("For possible timezones, see\n http://java.sun.com/j2se/1.5.0/docs/api/java/util/TimeZone.html");
    }

    public final void printUsage() {
        System.out.println("Usage: " + this.appname);
        for (OptionInfo optInfo : this.optinfolist) {
            if (optInfo.extended || optInfo.hidden) continue;
            this.basicOutput(optInfo);
        }
        this.printFinalLines();
    }

    private void printFinalLines() {
        System.out.println("\nEntries marked with an asterisk (*) are mandatory.");
        System.out.println("Entries marked with an question mark (?) are mandatory depending on your");
        System.out.println("configuration.");
        System.out.println("Entries marked with a pipe (|) are mandatory for one another which means that");
        System.out.println("at least one of them must be set.\n");
    }

    public final void printUsageExtended() {
        System.out.println("Usage: " + this.appname);
        for (OptionInfo optInfo : this.optinfolist) {
            this.basicOutput(optInfo);
        }
        this.printFinalLines();
    }

    public void removeOption(String shortForm, String longForm) {
        ArrayList<OptionInfo> removeList = new ArrayList<OptionInfo>();
        for (OptionInfo optInfo : this.optinfolist) {
            if (null != shortForm && shortForm.equals(optInfo.shortForm)) {
                removeList.add(optInfo);
                this.removeOption(optInfo.option);
                continue;
            }
            if (null == longForm || !longForm.equals(optInfo.longForm)) continue;
            removeList.add(optInfo);
            this.removeOption(optInfo.option);
        }
        this.optinfolist.removeAll(removeList);
    }

    private final void basicOutput(OptionInfo optInfo) {
        if (optInfo.shortForm == null) {
            String format_this = " %s %-45s%-2s%-28s\n";
            if (null != optInfo.longFormParameterDescription) {
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(optInfo.longForm);
                sb.append(" <");
                sb.append(optInfo.longFormParameterDescription);
                sb.append(">");
                Object[] format_with_ = new Object[]{"  ", sb.toString(), this.getrightmarker(optInfo.needed), optInfo.description};
                System.out.format(" %s %-45s%-2s%-28s\n", format_with_);
            } else {
                Object[] format_with_ = new Object[]{"  ", "--" + optInfo.longForm, this.getrightmarker(optInfo.needed), optInfo.description};
                System.out.format(" %s %-45s%-2s%-28s\n", format_with_);
            }
        } else {
            String format_this = " %s,%-45s%-2s%-28s\n";
            if (null != optInfo.longFormParameterDescription) {
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(optInfo.longForm);
                sb.append(" <");
                sb.append(optInfo.longFormParameterDescription);
                sb.append(">");
                Object[] format_with = new Object[]{"-" + optInfo.shortForm, sb.toString(), this.getrightmarker(optInfo.needed), optInfo.description};
                System.out.format(" %s,%-45s%-2s%-28s\n", format_with);
            } else {
                Object[] format_with = new Object[]{"-" + optInfo.shortForm, "--" + optInfo.longForm, this.getrightmarker(optInfo.needed), optInfo.description};
                System.out.format(" %s,%-45s%-2s%-28s\n", format_with);
            }
        }
    }

    private NeededQuadState convertBooleantoTriState(boolean needed) {
        if (needed) {
            return NeededQuadState.needed;
        }
        return NeededQuadState.notneeded;
    }

    private void checkOptionUniqueness() {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> longset = new HashSet<String>();
        for (OptionInfo optinfo : this.optinfolist) {
            if (null != optinfo.shortForm && !set.add(optinfo.shortForm)) {
                System.err.println(this.appname + ": The option: " + optinfo.shortForm + " for " + optinfo.description + " is duplicate");
                System.exit(1);
            }
            if (null == optinfo.longForm || longset.add(optinfo.longForm)) continue;
            System.err.println(this.appname + ": The option: " + optinfo.longForm + " for " + optinfo.description + " is duplicate");
            System.exit(1);
        }
        System.exit(0);
    }

    private String getrightmarker(NeededQuadState needed) {
        if (needed == NeededQuadState.needed) {
            return "*";
        }
        if (needed == NeededQuadState.possibly) {
            return "?";
        }
        if (needed == NeededQuadState.eitheror) {
            return "|";
        }
        return " ";
    }

    public void allowDynamicOptions() {
        this.allowDynamic = true;
    }

    public void forbidDynamicOptions() {
        this.allowDynamic = false;
    }

    public Map<String, Map<String, String>> getDynamicArguments() {
        return this.dynamicMaps;
    }

    private class OptionInfo {
        public NeededQuadState needed = NeededQuadState.notneeded;
        public CLIOption option = null;
        public String shortForm = null;
        public String longForm = null;
        public String longFormParameterDescription = null;
        public String description = null;
        public boolean extended = false;
        public boolean hidden = false;

        public OptionInfo(NeededQuadState needed, CLIOption option, char shortForm, String longForm, String longFormParameterDescription, String description) {
            this.needed = needed;
            this.option = option;
            this.shortForm = String.valueOf(shortForm);
            this.longForm = longForm;
            this.longFormParameterDescription = longFormParameterDescription;
            this.description = description;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, String longForm, String longFormParameterDescription, String description) {
            this.needed = needed;
            this.option = option;
            this.longForm = longForm;
            this.longFormParameterDescription = longFormParameterDescription;
            this.description = description;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, char shortForm, String longForm, String description) {
            this.needed = needed;
            this.option = option;
            this.shortForm = String.valueOf(shortForm);
            this.longForm = longForm;
            this.description = description;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, String longForm, String description) {
            this.needed = needed;
            this.option = option;
            this.longForm = longForm;
            this.description = description;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, String longForm, String description, boolean extended) {
            this.needed = needed;
            this.option = option;
            this.longForm = longForm;
            this.description = description;
            this.extended = extended;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, String longForm, String description, boolean extended, boolean hidden) {
            this.needed = needed;
            this.option = option;
            this.longForm = longForm;
            this.description = description;
            this.extended = extended;
            this.hidden = hidden;
        }

        public OptionInfo(NeededQuadState needed, CLIOption option, String longForm, String longFormParameterDescription, String description, boolean extended) {
            this.needed = needed;
            this.option = option;
            this.longForm = longForm;
            this.longFormParameterDescription = longFormParameterDescription;
            this.description = description;
            this.extended = extended;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NeededQuadState {
        notneeded,
        possibly,
        eitheror,
        needed;

    }
}

