/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.filestore;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.util.UtilAbstraction;
import com.openexchange.admin.rmi.dataobjects.Filestore;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class FilestoreAbstraction
extends UtilAbstraction {
    protected static final char OPT_NAME_STORE_FILESTORE_ID_SHORT = 'i';
    protected static final String OPT_NAME_STORE_FILESTORE_ID_LONG = "id";
    protected static final char OPT_NAME_STORE_PATH_SHORT = 't';
    protected static final String OPT_NAME_STORE_PATH_LONG = "storepath";
    protected static final char OPT_NAME_STORE_SIZE_SHORT = 's';
    protected static final String OPT_NAME_STORE_SIZE_LONG = "storesize";
    protected static final char OPT_NAME_STORE_MAX_CTX_SHORT = 'x';
    protected static final String OPT_NAME_STORE_MAX_CTX_LONG = "maxcontexts";
    protected CLIOption filestoreIdOption = null;
    protected CLIOption filestorePathOption = null;
    protected CLIOption filestoreSizeOption = null;
    protected CLIOption filestoreMaxContextsOption = null;
    protected String filestoreid = null;

    protected void parseAndSetFilestorePath(AdminParser parser, Filestore fstore) throws URISyntaxException {
        String store_path = (String)parser.getOptionValue(this.filestorePathOption);
        if (null != store_path) {
            URI uri = new URI(store_path);
            fstore.setUrl(uri.toString());
        }
    }

    protected void parseAndSetFilestoreSize(AdminParser parser, Filestore fstore) {
        String store_size = (String)parser.getOptionValue(this.filestoreSizeOption);
        if (store_size != null) {
            fstore.setSize(Long.valueOf(Long.parseLong(store_size)));
        }
    }

    protected void parseAndSetFilestoreMaxCtxs(AdminParser parser, Filestore fstore) {
        String store_max_ctx = (String)parser.getOptionValue(this.filestoreMaxContextsOption);
        if (store_max_ctx != null) {
            fstore.setMaxContexts(Integer.valueOf(Integer.parseInt(store_max_ctx)));
        }
    }

    protected void setPathOption(AdminParser parser, AdminParser.NeededQuadState needed) {
        this.filestorePathOption = this.setShortLongOpt(parser, 't', OPT_NAME_STORE_PATH_LONG, "Path to store filestore contents in URI format e.g. file:/tmp/filestore", true, needed);
    }

    protected void setSizeOption(AdminParser parser, String defaultvalue) {
        this.filestoreSizeOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 's', OPT_NAME_STORE_SIZE_LONG, "The maximum size of the filestore", defaultvalue, true, AdminParser.NeededQuadState.notneeded) : this.setShortLongOpt(parser, 's', OPT_NAME_STORE_SIZE_LONG, "The maximum size of the filestore", true, AdminParser.NeededQuadState.notneeded);
    }

    protected void setMaxCtxOption(AdminParser parser, String defaultvalue) {
        this.filestoreMaxContextsOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'x', OPT_NAME_STORE_MAX_CTX_LONG, "the maximum number of contexts", defaultvalue, true, AdminParser.NeededQuadState.notneeded) : this.setShortLongOpt(parser, 'x', OPT_NAME_STORE_MAX_CTX_LONG, "the maximum number of contexts", true, AdminParser.NeededQuadState.notneeded);
    }

    protected void setFilestoreIDOption(AdminParser parser, String command) {
        this.filestoreIdOption = this.setShortLongOpt(parser, 'i', OPT_NAME_STORE_FILESTORE_ID_LONG, "The id of the filestore which should be " + command, true, AdminParser.NeededQuadState.needed);
    }

    protected void parseAndSetFilestoreID(AdminParser parser, Filestore fstore) {
        this.filestoreid = (String)parser.getOptionValue(this.filestoreIdOption);
        fstore.setId(Integer.valueOf(Integer.parseInt(this.filestoreid)));
    }

    protected String getObjectName() {
        return "filestore";
    }
}

