/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.database;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.util.database.DatabaseAbstraction;
import com.openexchange.admin.rmi.OXUtilInterface;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Database;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDatabase
extends DatabaseAbstraction {
    public ListDatabase(String[] args2) {
        AdminParser parser = new AdminParser("listdatabase");
        this.setOptions(parser);
        try {
            parser.ownparse(args2);
            Credentials auth = this.credentialsparsing(parser);
            OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup(RMI_HOSTNAME + "OXUtil_V2");
            String searchpattern = "*";
            if (parser.getOptionValue(this.searchOption) != null) {
                searchpattern = (String)parser.getOptionValue(this.searchOption);
            }
            Database[] databases = oxutil.listDatabase(searchpattern, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(databases);
            } else {
                this.sysoutOutput(databases);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            this.printErrors(null, this.ctxid, e, parser);
        }
    }

    private void sysoutOutput(Database[] databases) throws InvalidDataException, URISyntaxException {
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Database database : databases) {
            data.add(this.makeStandardData(database, false));
        }
        this.doOutput(new String[]{"r", "l", "l", "l", "r", "r", "r", "r", "l", "r", "r"}, new String[]{"id", "name", "hostname", "master", "mid", "weight", "maxctx", "curctx", "hlimit", "max", "inital"}, data);
    }

    private void precsvinfos(Database[] databases) throws URISyntaxException, InvalidDataException {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("id");
        columns.add("display_name");
        columns.add("url");
        columns.add("master");
        columns.add("masterid");
        columns.add("clusterweight");
        columns.add("maxUnits");
        columns.add("currentunits");
        columns.add("poolHardLimit");
        columns.add("poolMax");
        columns.add("poolInitial");
        columns.add("login");
        columns.add("password");
        columns.add("driver");
        columns.add("read_id");
        columns.add("scheme");
        ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
        for (Database database : databases) {
            data.add(this.makeCSVData(database));
        }
        this.doCSVOutput(columns, data);
    }

    public static void main(String[] args) {
        new ListDatabase(args);
    }

    private void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setSearchOption(parser);
        this.setCSVOutputOption(parser);
    }

    private ArrayList<String> makeCSVData(Database db) throws URISyntaxException {
        ArrayList<String> rea_data = this.makeStandardData(db, true);
        if (null != db.getLogin()) {
            rea_data.add(db.getLogin());
        } else {
            rea_data.add(null);
        }
        if (null != db.getPassword()) {
            rea_data.add(db.getPassword());
        } else {
            rea_data.add(null);
        }
        if (null != db.getDriver()) {
            rea_data.add(db.getDriver());
        } else {
            rea_data.add(null);
        }
        if (null != db.getRead_id()) {
            rea_data.add(db.getRead_id().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getScheme()) {
            rea_data.add(db.getScheme().toString());
        } else {
            rea_data.add(null);
        }
        return rea_data;
    }

    private ArrayList<String> makeStandardData(Database db, boolean csv) throws URISyntaxException {
        ArrayList<String> rea_data = new ArrayList<String>();
        rea_data.add(db.getId().toString());
        if (null != db.getName()) {
            rea_data.add(db.getName());
        } else {
            rea_data.add(null);
        }
        if (null != db.getUrl()) {
            if (csv) {
                rea_data.add(db.getUrl());
            } else {
                rea_data.add(new URI(db.getUrl().substring("jdbc:".length())).getHost());
            }
        } else {
            rea_data.add(null);
        }
        if (null != db.isMaster()) {
            rea_data.add(db.isMaster().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getMasterId()) {
            rea_data.add(db.getMasterId().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getClusterWeight()) {
            rea_data.add(db.getClusterWeight().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getMaxUnits()) {
            rea_data.add(db.getMaxUnits().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getCurrentUnits()) {
            rea_data.add(db.getCurrentUnits().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getPoolHardLimit()) {
            if (csv) {
                rea_data.add(db.getPoolHardLimit().toString());
            } else {
                rea_data.add(db.getPoolHardLimit() > 0 ? "true" : "false");
            }
        } else {
            rea_data.add(null);
        }
        if (null != db.getPoolMax()) {
            rea_data.add(db.getPoolMax().toString());
        } else {
            rea_data.add(null);
        }
        if (null != db.getPoolInitial()) {
            rea_data.add(db.getPoolInitial().toString());
        } else {
            rea_data.add(null);
        }
        return rea_data;
    }

    @Override
    protected final String getObjectName() {
        return "databases";
    }
}

