/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.util.database;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.console.util.UtilAbstraction;
import com.openexchange.admin.rmi.dataobjects.Database;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;

public abstract class DatabaseAbstraction
extends UtilAbstraction {
    protected static final char OPT_NAME_DATABASE_ID_SHORT = 'i';
    protected static final String OPT_NAME_DATABASE_ID_LONG = "id";
    protected static final char OPT_NAME_DB_USERNAME_SHORT = 'u';
    protected static final String OPT_NAME_DB_USERNAME_LONG = "dbuser";
    protected static final char OPT_NAME_DBNAME_SHORT = 'n';
    protected static final String OPT_NAME_DBNAME_LONG = "name";
    protected static final char OPT_NAME_DB_PASSWD_SHORT = 'p';
    protected static final String OPT_NAME_DB_PASSWD_LONG = "dbpasswd";
    protected static final char OPT_NAME_POOL_HARDLIMIT_SHORT = 'l';
    protected static final String OPT_NAME_POOL_HARDLIMIT_LONG = "poolhardlimit";
    protected static final char OPT_NAME_POOL_INITIAL_SHORT = 'o';
    protected static final String OPT_NAME_POOL_INITIAL_LONG = "poolinitial";
    protected static final char OPT_NAME_POOL_MAX_SHORT = 'a';
    protected static final String OPT_NAME_POOL_MAX_LONG = "poolmax";
    protected static final char OPT_NAME_DB_DRIVER_SHORT = 'd';
    protected static final String OPT_NAME_DB_DRIVER_LONG = "dbdriver";
    protected static final char OPT_NAME_MASTER_ID_SHORT = 'M';
    protected static final String OPT_NAME_MASTER_ID_LONG = "masterid";
    protected static final char OPT_NAME_WEIGHT_SHORT = 'w';
    protected static final String OPT_NAME_WEIGHT_LONG = "dbweight";
    protected static final char OPT_NAME_MAX_UNITS_SHORT = 'x';
    protected static final String OPT_NAME_MAX_UNITS_LONG = "maxunit";
    protected static final char OPT_NAME_HOSTNAME_SHORT = 'H';
    protected static final String OPT_NAME_HOSTNAME_LONG = "hostname";
    protected static final char OPT_NAME_IS_MASTER_SHORT = 'm';
    protected static final String OPT_NAME_IS_MASTER_LONG = "master";
    protected CLIOption databaseIdOption = null;
    protected CLIOption databaseUsernameOption = null;
    protected CLIOption databaseDriverOption = null;
    protected CLIOption databasePasswdOption = null;
    protected CLIOption databaseIsMasterOption = null;
    protected CLIOption databaseMasterIDOption = null;
    protected CLIOption databaseWeightOption = null;
    protected CLIOption databaseNameOption = null;
    protected CLIOption hostnameOption = null;
    protected CLIOption maxUnitsOption = null;
    protected CLIOption poolHardlimitOption = null;
    protected CLIOption poolInitialOption = null;
    protected CLIOption poolMaxOption = null;
    protected String dbid = null;
    protected String dbname = null;

    protected void parseAndSetDatabaseID(AdminParser parser, Database db) {
        this.dbid = (String)parser.getOptionValue(this.databaseIdOption);
        if (null != this.dbid) {
            db.setId(Integer.valueOf(Integer.parseInt(this.dbid)));
        }
    }

    protected void parseAndSetDatabasename(AdminParser parser, Database db) {
        this.dbname = (String)parser.getOptionValue(this.databaseNameOption);
        if (null != this.dbname) {
            db.setName(this.dbname);
        }
    }

    private void parseAndSetHostname(AdminParser parser, Database db) {
        String hostname = (String)parser.getOptionValue(this.hostnameOption);
        if (null != hostname) {
            db.setUrl("jdbc:mysql://" + hostname + "/?useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&useUnicode=true&useServerPrepStmts=false&useTimezone=true&serverTimezone=UTC&connectTimeout=15000&socketTimeout=15000");
        }
    }

    private void parseAndSetPasswd(AdminParser parser, Database db) {
        String passwd = (String)parser.getOptionValue(this.databasePasswdOption);
        if (null != passwd) {
            db.setPassword(passwd);
        }
    }

    private void parseAndSetPoolmax(AdminParser parser, Database db) {
        String pool_max = (String)parser.getOptionValue(this.poolMaxOption);
        if (pool_max != null) {
            db.setPoolMax(Integer.valueOf(Integer.parseInt(pool_max)));
        }
    }

    private void parseAndSetPoolInitial(AdminParser parser, Database db) {
        String pool_initial = (String)parser.getOptionValue(this.poolInitialOption);
        if (null != pool_initial) {
            db.setPoolInitial(Integer.valueOf(Integer.parseInt(pool_initial)));
        }
    }

    private void parseAndSetPoolHardLimit(AdminParser parser, Database db) throws InvalidDataException {
        String pool_hard_limit = (String)parser.getOptionValue(this.poolHardlimitOption);
        if (pool_hard_limit != null) {
            if (!pool_hard_limit.matches("true|false")) {
                throw new InvalidDataException("Only true or false are allowed for poolhardlimit");
            }
            db.setPoolHardLimit(Integer.valueOf(Boolean.parseBoolean(pool_hard_limit) ? 1 : 0));
        }
    }

    private void parseAndSetMaxUnits(AdminParser parser, Database db) {
        String maxunits = (String)parser.getOptionValue(this.maxUnitsOption);
        if (maxunits != null) {
            db.setMaxUnits(Integer.valueOf(Integer.parseInt(maxunits)));
        }
    }

    private void parseAndSetDatabaseWeight(AdminParser parser, Database db) {
        String databaseweight = (String)parser.getOptionValue(this.databaseWeightOption);
        if (databaseweight != null) {
            db.setClusterWeight(Integer.valueOf(Integer.parseInt(databaseweight)));
        }
    }

    private void parseAndSetDBUsername(AdminParser parser, Database db) {
        String username = (String)parser.getOptionValue(this.databaseUsernameOption);
        if (null != username) {
            db.setLogin(username);
        }
    }

    private void parseAndSetDriver(AdminParser parser, Database db) {
        String driver = (String)parser.getOptionValue(this.databaseDriverOption);
        if (driver != null) {
            db.setDriver(driver);
        }
    }

    protected void parseAndSetMasterAndID(AdminParser parser, Database db) throws InvalidDataException {
        Boolean ismaster = null;
        String databaseismaster = (String)parser.getOptionValue(this.databaseIsMasterOption);
        if (databaseismaster != null) {
            ismaster = Boolean.parseBoolean(databaseismaster);
            db.setMaster(ismaster);
        }
        String databasemasterid = (String)parser.getOptionValue(this.databaseMasterIDOption);
        if (null != ismaster && !ismaster.booleanValue()) {
            if (databasemasterid != null) {
                db.setMasterId(Integer.valueOf(Integer.parseInt(databasemasterid)));
            } else {
                this.printError(null, null, "master id must be set if this database isn't the master", parser);
                parser.printUsage();
                this.sysexit(104);
            }
        } else if ((null == ismaster || ismaster.booleanValue()) && databasemasterid != null) {
            throw new InvalidDataException("Master ID can only be set if this is a slave.");
        }
    }

    protected void setDatabaseIDOption(AdminParser parser) {
        this.databaseIdOption = this.setShortLongOpt(parser, 'i', OPT_NAME_DATABASE_ID_LONG, "The id of the database.", true, AdminParser.NeededQuadState.eitheror);
    }

    protected void setDatabasePoolMaxOption(AdminParser parser, String defaultvalue, boolean required) {
        this.poolMaxOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'a', OPT_NAME_POOL_MAX_LONG, "Db pool max", defaultvalue, true, this.convertBooleantoTriState(required)) : this.setShortLongOpt(parser, 'a', OPT_NAME_POOL_MAX_LONG, "Db pool max", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabasePoolInitialOption(AdminParser parser, String defaultvalue, boolean required) {
        this.poolInitialOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'o', OPT_NAME_POOL_INITIAL_LONG, "Db pool initial", defaultvalue, true, this.convertBooleantoTriState(required)) : this.setShortLongOpt(parser, 'o', OPT_NAME_POOL_INITIAL_LONG, "Db pool initial", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseHostnameOption(AdminParser parser, boolean required) {
        this.hostnameOption = this.setShortLongOpt(parser, 'H', OPT_NAME_HOSTNAME_LONG, "Hostname of the server", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseUsernameOption(AdminParser parser, boolean required) {
        this.databaseUsernameOption = this.setShortLongOpt(parser, 'u', OPT_NAME_DB_USERNAME_LONG, "Name of the user for the database", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseDriverOption(AdminParser parser, String defaultvalue, boolean required) {
        this.databaseDriverOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'd', OPT_NAME_DB_DRIVER_LONG, "The driver to be used for the database", defaultvalue, true, this.convertBooleantoTriState(required)) : this.setShortLongOpt(parser, 'd', OPT_NAME_DB_DRIVER_LONG, "The driver to be used for the database", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabasePasswdOption(AdminParser parser, boolean required) {
        this.databasePasswdOption = this.setShortLongOpt(parser, 'p', OPT_NAME_DB_PASSWD_LONG, "Password for the database", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseIsMasterOption(AdminParser parser, boolean required) {
        this.databaseIsMasterOption = this.setShortLongOpt(parser, 'm', OPT_NAME_IS_MASTER_LONG, "true/false", "Set this if the registered database is the master", required);
    }

    protected void setDatabaseMasterIDOption(AdminParser parser, boolean required) {
        this.databaseMasterIDOption = this.setShortLongOpt(parser, 'M', OPT_NAME_MASTER_ID_LONG, "If this database isn't the master give the id of the master here", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseWeightOption(AdminParser parser, String defaultvalue, boolean required) {
        this.databaseWeightOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'w', OPT_NAME_WEIGHT_LONG, "The db weight for this database", defaultvalue, true, this.convertBooleantoTriState(required)) : this.setShortLongOpt(parser, 'w', OPT_NAME_WEIGHT_LONG, "The db weight for this database", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabaseMaxUnitsOption(AdminParser parser, String defaultvalue, boolean required) {
        this.maxUnitsOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'x', OPT_NAME_MAX_UNITS_LONG, "The maximum number of contexts in this database.", defaultvalue, true, this.convertBooleantoTriState(required)) : this.setShortLongOpt(parser, 'x', OPT_NAME_MAX_UNITS_LONG, "The maximum number of contexts in this database.", true, this.convertBooleantoTriState(required));
    }

    protected void setDatabasePoolHardlimitOption(AdminParser parser, String defaultvalue, boolean required) {
        this.poolHardlimitOption = null != defaultvalue ? this.setShortLongOptWithDefault(parser, 'l', OPT_NAME_POOL_HARDLIMIT_LONG, "true/false", "Db pool hardlimit", defaultvalue, required) : this.setShortLongOpt(parser, 'l', OPT_NAME_POOL_HARDLIMIT_LONG, "true/false", "Db pool hardlimit", required);
    }

    protected void setDatabaseNameOption(AdminParser parser, AdminParser.NeededQuadState required) {
        this.databaseNameOption = this.setShortLongOpt(parser, 'n', OPT_NAME_DBNAME_LONG, "Name of the database", true, required);
    }

    protected String getObjectName() {
        return "database";
    }

    protected void parseAndSetMandatoryOptions(AdminParser parser, Database db) throws InvalidDataException {
        this.parseAndSetHostname(parser, db);
        this.parseAndSetDriver(parser, db);
        this.parseAndSetDBUsername(parser, db);
        this.parseAndSetPasswd(parser, db);
        this.parseAndSetMaxUnits(parser, db);
        this.parseAndSetPoolHardLimit(parser, db);
        this.parseAndSetPoolInitial(parser, db);
        this.parseAndSetPoolmax(parser, db);
        this.parseAndSetDatabaseWeight(parser, db);
    }
}

