/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console.context;

import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.context.ContextAbstraction;
import com.openexchange.admin.rmi.OXContextInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Filestore;
import java.rmi.Naming;

public class ListContextByFilestore
extends ContextAbstraction {
    protected void setOptions(AdminParser parser) {
        this.setDefaultCommandLineOptionsWithoutContextID(parser);
        this.setFilestoreIdOption(parser);
        this.setCSVOutputOption(parser);
    }

    public ListContextByFilestore(String[] args2) {
        AdminParser parser = new AdminParser("listcontext");
        this.setOptions(parser);
        try {
            parser.ownparse(args2);
            Filestore fs = this.parseAndSetFilestoreId(parser);
            Credentials auth = this.credentialsparsing(parser);
            OXContextInterface oxctx = (OXContextInterface)Naming.lookup(RMI_HOSTNAME + "OXContext_V2");
            Context[] ctxs = oxctx.listByFilestore(fs, auth);
            if (null != parser.getOptionValue(this.csvOutputOption)) {
                this.precsvinfos(ctxs, parser);
            } else {
                this.sysoutOutput(ctxs, parser);
            }
            this.sysexit(0);
        }
        catch (Exception e) {
            if (null == this.getFilestoreid()) {
                this.printErrors(null, null, e, parser);
            }
            this.printErrors(String.valueOf(this.getFilestoreid()), null, e, parser);
        }
    }

    public static void main(String[] args) {
        new ListContextByFilestore(args);
    }

    protected final String getObjectName() {
        return "contexts for filestore";
    }
}

