/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.admin.console;

import com.openexchange.admin.console.AbstractJMXTools;
import com.openexchange.admin.console.AdminParser;
import com.openexchange.admin.console.CLIOption;
import com.openexchange.admin.rmi.exceptions.InvalidDataException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticTools
extends AbstractJMXTools {
    private static final char OPT_STATS_SHORT = 'x';
    private static final String OPT_STATS_LONG = "xchangestats";
    private static final char OPT_RUNTIME_STATS_SHORT = 'r';
    private static final String OPT_RUNTIME_STATS_LONG = "runtimestats";
    private static final char OPT_OS_STATS_SHORT = 'o';
    private static final String OPT_OS_STATS_LONG = "osstats";
    private static final char OPT_THREADING_STATS_SHORT = 't';
    private static final String OPT_THREADING_STATS_LONG = "threadingstats";
    private static final char OPT_ALL_STATS_SHORT = 'a';
    private static final String OPT_ALL_STATS_LONG = "allstats";
    private static final char OPT_ADMINDAEMON_STATS_SHORT = 'A';
    private static final String OPT_ADMINDAEMON_STATS_LONG = "admindaemonstats";
    private static final char OPT_SHOWOPERATIONS_STATS_SHORT = 's';
    private static final String OPT_SHOWOPERATIONS_STATS_LONG = "showoperations";
    private static final char OPT_DOOPERATIONS_STATS_SHORT = 'd';
    private static final String OPT_DOOPERATIONS_STATS_LONG = "dooperation";
    private CLIOption xchangestats = null;
    private CLIOption runtimestats = null;
    private CLIOption osstats = null;
    private CLIOption threadingstats = null;
    private CLIOption allstats = null;
    private CLIOption admindaemonstats = null;
    private CLIOption showoperation = null;
    private CLIOption dooperation = null;

    public static void main(String[] args) {
        StatisticTools st = new StatisticTools();
        st.start(args, "showruntimestats");
    }

    protected void furtherOptionsHandling(AdminParser parser, HashMap<String, String[]> env) throws InterruptedException, IOException, InstanceNotFoundException, AttributeNotFoundException, IntrospectionException, MBeanException, ReflectionException, MalformedObjectNameException, InvalidDataException {
        String operation;
        MBeanServerConnection initConnection;
        boolean admin = false;
        if (null != parser.getOptionValue(this.admindaemonstats)) {
            admin = true;
        }
        int count = 0;
        if (null != parser.getOptionValue(this.xchangestats)) {
            initConnection = this.initConnection(admin, env);
            this.showOXData(initConnection, admin);
            ++count;
        }
        if (null != parser.getOptionValue(this.runtimestats)) {
            if (0 == count) {
                initConnection = this.initConnection(admin, env);
                System.out.print(this.getStats(initConnection, "sun.management.RuntimeImpl"));
                this.showMemoryPoolData(initConnection);
            }
            ++count;
        }
        if (null != parser.getOptionValue(this.osstats)) {
            if (0 == count) {
                initConnection = this.initConnection(admin, env);
                System.out.print(this.getStats(initConnection, "com.sun.management.UnixOperatingSystem"));
            }
            ++count;
        }
        if (null != parser.getOptionValue(this.threadingstats)) {
            if (0 == count) {
                initConnection = this.initConnection(admin, env);
                this.showSysThreadingData(initConnection);
            }
            ++count;
        }
        if (null != parser.getOptionValue(this.allstats)) {
            if (0 == count) {
                initConnection = this.initConnection(admin, env);
                this.showOXData(initConnection, admin);
                System.out.print(this.getStats(initConnection, "com.sun.management.UnixOperatingSystem"));
                System.out.print(this.getStats(initConnection, "sun.management.RuntimeImpl"));
                this.showMemoryPoolData(initConnection);
                this.showSysThreadingData(initConnection);
            }
            ++count;
        }
        if (null != parser.getOptionValue(this.showoperation)) {
            if (0 == count) {
                initConnection = this.initConnection(admin, env);
                this.showOperations(initConnection);
            }
            ++count;
        }
        if (null != (operation = (String)parser.getOptionValue(this.dooperation))) {
            MBeanServerConnection initConnection2;
            Object result;
            if (0 == count && null != (result = this.doOperation(initConnection2 = this.initConnection(admin, env), operation))) {
                System.out.println(result);
            }
            ++count;
            System.out.println("Done");
        }
        if (0 == count) {
            System.err.println(new StringBuilder("No option selected (").append(OPT_STATS_LONG).append(", ").append(OPT_RUNTIME_STATS_LONG).append(", ").append(OPT_OS_STATS_LONG).append(", ").append(OPT_THREADING_STATS_LONG).append(", ").append(OPT_ALL_STATS_LONG).append(")"));
            parser.printUsage();
        } else if (count > 1) {
            System.err.println("More than one of the stat options given. Using the first one only");
        }
    }

    protected void setFurtherOptions(AdminParser parser) {
        this.xchangestats = this.setShortLongOpt(parser, 'x', OPT_STATS_LONG, "shows Open-Xchange stats", false, AdminParser.NeededQuadState.notneeded);
        this.runtimestats = this.setShortLongOpt(parser, 'r', OPT_RUNTIME_STATS_LONG, "shows Java runtime stats", false, AdminParser.NeededQuadState.notneeded);
        this.osstats = this.setShortLongOpt(parser, 'o', OPT_OS_STATS_LONG, "shows operating system stats", false, AdminParser.NeededQuadState.notneeded);
        this.threadingstats = this.setShortLongOpt(parser, 't', OPT_THREADING_STATS_LONG, "shows threading stats", false, AdminParser.NeededQuadState.notneeded);
        this.allstats = this.setShortLongOpt(parser, 'a', OPT_ALL_STATS_LONG, "shows all stats", false, AdminParser.NeededQuadState.notneeded);
        this.admindaemonstats = this.setShortLongOpt(parser, 'A', OPT_ADMINDAEMON_STATS_LONG, "shows stats for the admin instead of the groupware", false, AdminParser.NeededQuadState.notneeded);
        this.showoperation = this.setShortLongOpt(parser, 's', OPT_SHOWOPERATIONS_STATS_LONG, "shows the operations for the registered beans", false, AdminParser.NeededQuadState.notneeded);
        this.dooperation = this.setShortLongOpt(parser, 'd', OPT_DOOPERATIONS_STATS_LONG, "operation", "Syntax is <canonical object name (the first part from showoperatons)>!<operationname>", false);
    }

    private void showMemoryPoolData(MBeanServerConnection mbc) throws InstanceNotFoundException, AttributeNotFoundException, IntrospectionException, MBeanException, ReflectionException, IOException {
        System.out.print(this.getStats(mbc, ManagementFactory.getMemoryPoolMXBeans().get(0).getClass().getName()));
    }

    private void showSysThreadingData(MBeanServerConnection mbc) throws InstanceNotFoundException, AttributeNotFoundException, IntrospectionException, MBeanException, ReflectionException, IOException {
        System.out.print(this.getStats(mbc, ManagementFactory.getThreadMXBean().getClass().getName()));
    }

    private void showOXData(MBeanServerConnection mbc, boolean admin) throws InstanceNotFoundException, AttributeNotFoundException, IntrospectionException, MBeanException, ReflectionException, IOException {
        if (admin) {
            System.out.print(this.getStats(mbc, "com.openexchange.admin.tools.monitoring.Monitor"));
        } else {
            System.out.print(this.getStats(mbc, "com.openexchange.ajp13.monitoring.AJPv13ServerThreadsMonitor"));
            System.out.print(this.getStats(mbc, "com.openexchange.ajp13.najp.AJPv13TaskMonitor"));
            System.out.print(this.getStats(mbc, "com.openexchange.monitoring.internal.GeneralMonitor"));
            System.out.print(this.getStats(mbc, "com.openexchange.api2.MailInterfaceMonitor"));
            System.out.print(this.getStats(mbc, "com.openexchange.database.internal.ConnectionPool"));
            System.out.print(this.getStats(mbc, "com.openexchange.database.internal.Overview"));
        }
    }

    private void showOperations(MBeanServerConnection mbc) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        Set<ObjectName> queryNames = mbc.queryNames(null, null);
        for (ObjectName objname : queryNames) {
            MBeanOperationInfo[] operations;
            MBeanInfo beanInfo = mbc.getMBeanInfo(objname);
            for (MBeanOperationInfo operation : operations = beanInfo.getOperations()) {
                System.out.println(new StringBuilder(objname.getCanonicalName()).append(", operationname: ").append(operation.getName()).append(", desciption: ").append(operation.getDescription()));
            }
        }
    }
}

