package com.openexchange.templating.json.osgi;

import com.openexchange.multiple.MultipleHandler;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.server.osgiservice.DeferredActivator;
import com.openexchange.templating.base.TemplateService;
import com.openexchange.templating.json.TemplateMultipleHandler;
import com.openexchange.templating.json.TemplatingServlet;
import com.openexchange.tools.service.SessionServletRegistration;

public class TemplatingJSONActivator extends DeferredActivator {

    /**
     * 
     */
    private static final String SERVLET_PATH = "ajax/templating";
    private SessionServletRegistration registration;

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class[]{TemplateService.class};
    }

    @Override
    protected void handleAvailability(final Class<?> clazz) {
    }

    @Override
    protected void handleUnavailability(final Class<?> clazz) {
    }

    @Override
    protected void startBundle() throws Exception {
    	try {
        TemplateMultipleHandler.setServices(this);
    	} catch(Throwable x) {
    		x.printStackTrace();
    	}
        
        context.registerService(MultipleHandlerFactoryService.class.getName(), new MultipleHandlerFactoryService() {

            private final MultipleHandler HANDLER = new TemplateMultipleHandler();
            
            public MultipleHandler createMultipleHandler() {
                return HANDLER;
            }

            public String getSupportedModule() {
                return "templating";
            }
            
        }, null);
        
        registration = new SessionServletRegistration(context, new TemplatingServlet(), SERVLET_PATH);
    }

    @Override
    protected void stopBundle() throws Exception {
        if (null != registration) {
            registration.remove();
            registration = null;
        }
    }

}
