/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.templating.json.actions;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.templating.base.OXTemplate;
import com.openexchange.templating.base.TemplateException;
import com.openexchange.templating.base.TemplateService;
import com.openexchange.templating.json.TemplateMultipleHandler;
import com.openexchange.tools.session.ServerSession;

public class RenderAction {

	public Object perform(JSONObject json, ServerSession session) throws JSONException, TemplateException{
		String templateName = json.getString(AJAXServlet.PARAMETER_TEMPLATE);
		
        TemplateService templates = TemplateMultipleHandler.getServices().getService(TemplateService.class);
        OXTemplate template = templates.loadTemplate(templateName);
		Map<String, String> parameters = retrieveTemplateVars(json.getJSONObject("data"));

		StringWriter writer = new StringWriter();
		template.process(parameters, writer);
		return writer.toString();
	}


	public Map<String, String> retrieveTemplateVars(JSONObject json) throws JSONException {
		Map<String, String> vars = new HashMap<String,String>();

		JSONArray keys = json.names();
		if(keys != null){
			for(int i = 0, max = keys.length(); i < max; i++){
				String key = keys.getString(i);
				vars.put(key, json.getString(key));
			}
		}
		return vars;
	}
}
