/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.oauth.yahoo.osgi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import com.openexchange.config.ConfigurationService;
import com.openexchange.http.deferrer.DeferringURLService;
import com.openexchange.oauth.OAuthService;
import com.openexchange.oauth.OAuthServiceMetaData;
import com.openexchange.oauth.yahoo.YahooService;
import com.openexchange.oauth.yahoo.internal.OAuthServiceMetaDataYahooImpl;
import com.openexchange.oauth.yahoo.internal.YahooServiceImpl;
import com.openexchange.server.osgiservice.HousekeepingActivator;

/**
 * {@link YahooOAuthActivator}
 *
 * @author <a href="mailto:karsten.will@open-xchange.com">Karsten Will</a>
 */
public class YahooOAuthActivator extends HousekeepingActivator {

    private static final Class[] NEEDED = new Class[] { ConfigurationService.class, OAuthService.class, DeferringURLService.class };

    private static final String API_KEY = "com.openexchange.oauth.yahoo.apiKey";

    private static final String API_SECRET = "com.openexchange.oauth.yahoo.apiSecret";

    private OAuthService oauthService;

    private OAuthServiceMetaDataYahooImpl oAuthMetaData;

    private static final Log LOG = com.openexchange.log.Log.valueOf(LogFactory.getLog(YahooOAuthActivator.class));

    public OAuthService getOauthService() {
        return oauthService;
    }


    public void setOauthService(OAuthService oauthService) {
        this.oauthService = oauthService;
    }


    public OAuthServiceMetaDataYahooImpl getOAuthMetaData() {
        return oAuthMetaData;
    }


    public void setOAuthMetaData(OAuthServiceMetaDataYahooImpl oauthMetaData) {
        this.oAuthMetaData = oauthMetaData;
    }


    /* (non-Javadoc)
     * @see com.openexchange.server.osgiservice.DeferredActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return NEEDED;
    }


    /* (non-Javadoc)
     * @see com.openexchange.server.osgiservice.DeferredActivator#startBundle()
     */
    @Override
    protected void startBundle() throws Exception {
        ConfigurationService config = getService(ConfigurationService.class);
        oauthService = getService(OAuthService.class);

        oAuthMetaData = new OAuthServiceMetaDataYahooImpl(config.getProperty(API_KEY), config.getProperty(API_SECRET), getService(DeferringURLService.class));

        registerService(OAuthServiceMetaData.class, oAuthMetaData);
        LOG.info("OAuthServiceMetaData for Yahoo was started");
        LOG.info("API-Key for Yahoo : "+config.getProperty(API_KEY)+", API-Secret for Yahoo : "+config.getProperty(API_SECRET));

        final YahooService yahooService = new YahooServiceImpl(this);

        registerService(YahooService.class, yahooService);
        LOG.info("YahooService was started.");

    }



}
