
# norootforbuild

Name:           open-xchange-mobile-configuration-gui
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  ant
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:        6.20.7.0
%define         ox_release 15
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Open-Xchange Gui for Mobility Configuration.
Requires:       open-xchange-gui >= 6.20.7.0 open-xchange-help-usm-eas >= 6.20.7.0
#

%description
Open-Xchange Gui for Mobility Configuration.

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif

ant -Dguiprefix=%{docroot}/ox6 -Dlib.dir=/opt/open-xchange/lib -Ddestdir=%{buildroot} -Dprefix=/opt/open-xchange install

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir %{docroot}/ox6/plugins/com.openexchange.mobile.configuration.gui
%{docroot}/ox6/plugins/com.openexchange.mobile.configuration.gui/*

%changelog
* Fri Aug 26 2011 - wolfgang.rosenauer@open-xchange.com
  - Fixed bug #20198 : [L3] 'Open-Xchange Server' not replaced everywhere with oxProductInfo.product_name
* Fri Jul 01 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19426 : [L3] mobility icon missing in wizard welcome page
* Thu May 12 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #19092 : Mobility tab in wizard throws error message for pim_mobility users
* Tue May 10 2011 - stefan.preuss@open-xchange.com
  - Fixed bug #19072 : [L3] The "Send" button is not transated into Chinese
  - Fixed bug #19059 : [L3] "Mobile Phone" plugin prompts JavaScript Error when testing with IE7
* Wed Apr 06 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #18872 : [L3] Mobility configuration page in Wizard needs some polishing
* Tue Apr 05 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #18847 : wizard: external window opens for mobile eas device configuration
* Mon Apr 04 2011 - viktor.pracht@open-xchange.com
  - Enabled theming of wizard plugins
* Tue Mar 15 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #18631 : [L3] Mobility visible without function if eas is not enabled for the user and no upsell active
* Wed Mar 09 2011 - viktor.pracht@open-xchange.com
  - Implemented US5424 : wizard: mobility html pages to directly show username and server URL for configuration
* Fri Feb 18 2011 - viktor.pracht@open-xchange.com
  - Fixed bug #16611 : Mobile config: Mail address is not removed when switching to SMS
* Mon Jan 31 2011 - choeger@open-xchange.com
  - Fixed bug #18181 : open-xchange-mobile-configuration-gui installs to
    /var/www on SLES and RHEL
* Tue Nov 23 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #17622 : Mobile Autoconfig Plugin does not work in Wizard
  - Fixed bug #17616 : [L3] mobile-configuration-gui product name not branded
* Thu Nov 11 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #17505 : Mobile Autoconfig Plugin does not work
* Thu Jul 29 2010 - benjamin.otterbach@open-xchange.com
  - Fixed Bug #16587 : Autoconfig: No device selection possible
  - Fixed Bug #16573 : Mobility configuration wizard icon is missing
* Mon Jul 26 2010 - benjamin.otterbach@open-xchange.com
  - Removed UI activator file for server
  - Removed package dependency to open-xchange-help-usm-eas
  - Fixed wrong image location
* Fri Jul 16 2010 - viktor.pracht@open-xchange.com
  - Fixed bug #16512 : list of devices in wizard tab gets duplicated on each wizard load
  - Fixed bug #16513 : list of numbers/emails in wizard tab gets duplicated and mixed on each sms/mail content load
* Mon Jul 05 2010 - benjamin.otterbach@open-xchange.com
  - Initial import
