/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.configuration.generator.test;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.mobile.configuration.generator.MobileConfigSigner;
import com.openexchange.mobile.configuration.generator.configuration.ConfigurationException;
import com.openexchange.mobile.configuration.generator.configuration.Property;
import com.openexchange.mobile.configuration.generator.services.MobileConfigServiceRegistry;
import com.openexchange.threadpool.SimThreadPoolService;
import com.openexchange.threadpool.ThreadPoolService;


public class MobileConfigSignerTest {
    
    private static final String SIGNEDJAVA_MOBILECONFIG = "testdata/signedjava.mobileconfig";
    private static final String EAS_MOBILECONFIG = "testdata/eas.mobileconfig";

    @Before
    public void setUp(){
        final SimConfigurationService service = new SimConfigurationService();
        service.stringProperties.put(Property.OpensslBinary.getName(), "/usr/bin/openssl");
        service.stringProperties.put(Property.CertFile.getName(), "testdata/testcert.pem");
        service.stringProperties.put(Property.KeyFile.getName(), "testdata/testkey.pem");
        service.stringProperties.put(Property.OpensslTimeout.getName(), "2000");
        MobileConfigServiceRegistry.getServiceRegistry().addService(ConfigurationService.class, service);
        MobileConfigServiceRegistry.getServiceRegistry().addService(ThreadPoolService.class, new SimThreadPoolService());
    }

    /**
     * FIXME configuration for this test is missing. Especially the certificate files. See {@link #setUp()} where "define"
     */
    @Test
    public void signerTest() throws IOException, ConfigurationException {
        final FileReader fileReader = new FileReader(EAS_MOBILECONFIG);
        final FileOutputStream fileWriter = new FileOutputStream(SIGNEDJAVA_MOBILECONFIG);
        final MobileConfigSigner mobileConfigSigner = new MobileConfigSigner(fileWriter);
        final char[] buf = new char[1024];
        int read;
        while (-1 != (read = fileReader.read(buf))) {
            mobileConfigSigner.write(buf, 0, read);
        }
        mobileConfigSigner.close();
        fileReader.close();
    }

    @Test
    public void signerTestTooLong() throws IOException, ConfigurationException {
        final FileReader fileReader = new FileReader(EAS_MOBILECONFIG);
        final FileOutputStream fileWriter = new FileOutputStream(SIGNEDJAVA_MOBILECONFIG);
        final MobileConfigSigner mobileConfigSigner = new MobileConfigSigner(fileWriter) {
            @Override
            protected String[] getCommand() {
                return new String[]{ "sleep", "10" };
            }
        };
        final char[] buf = new char[1024];
        int read;
        while (-1 != (read = fileReader.read(buf))) {
            mobileConfigSigner.write(buf, 0, read);
        }
        try {
            mobileConfigSigner.close();
            Assert.fail("No exception thrown");
        } catch (final IOException e) {
            Assert.assertTrue("Wrong exception message: " + e.getMessage(), MobileConfigSigner.OPENSSL_DIDN_T_RETURN_IN_A_TIMELY_MANNER_KILLED_PROCESS.equals(e.getMessage()));
        }

        fileReader.close();
    }
    
    @Test
    public void signerTestWrongResult() throws IOException, ConfigurationException {
        final FileReader fileReader = new FileReader(EAS_MOBILECONFIG);
        final FileOutputStream fileWriter = new FileOutputStream(SIGNEDJAVA_MOBILECONFIG);
        final MobileConfigSigner mobileConfigSigner = new MobileConfigSigner(fileWriter) {
            @Override
            protected String[] getCommand() {
                return new String[]{ "/bin/false" };
            }
        };
        final char[] buf = new char[1024];
        int read;
        read = fileReader.read(buf);
        mobileConfigSigner.write(buf, 0, read);
        try {
            mobileConfigSigner.close();
            Assert.fail("No exception thrown");
        } catch (final IOException e) {
            Assert.assertTrue("Wrong exception message: " + e.getMessage(), (MobileConfigSigner.OPENSSL_EXITED_UNEXPECTEDLY_WITH + 1).equals(e.getMessage()));
        }
    }
}
