/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherEvent;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.FetcherListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractFeedFetcher
implements FeedFetcher {
    private final Set fetcherEventListeners = Collections.synchronizedSet(new HashSet());
    private String userAgent;
    private boolean usingDeltaEncoding;
    private boolean preserveWireFeed;

    public AbstractFeedFetcher() {
        Properties props = new Properties(System.getProperties());
        String resourceName = "fetcher.properties";
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            }
            if (inputStream != null) {
                props.load(inputStream);
                System.getProperties().putAll((Map<?, ?>)props);
                inputStream.close();
            } else {
                System.err.println("Could not find " + resourceName + " on classpath");
            }
        }
        catch (IOException e) {
            System.err.println("Error reading " + resourceName + " from classpath: " + e.getMessage());
        }
        this.setUserAgent("Rome Client (http://tinyurl.com/64t5n) Ver: " + System.getProperty("rome.fetcher.version", "UNKNOWN"));
    }

    public synchronized String getUserAgent() {
        return this.userAgent;
    }

    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    protected void fireEvent(String eventType, URLConnection connection) {
        this.fireEvent(eventType, connection.getURL().toExternalForm(), null);
    }

    protected void fireEvent(String eventType, URLConnection connection, SyndFeed feed) {
        this.fireEvent(eventType, connection.getURL().toExternalForm(), feed);
    }

    protected void fireEvent(String eventType, String urlStr) {
        this.fireEvent(eventType, urlStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(String eventType, String urlStr, SyndFeed feed) {
        FetcherEvent fetcherEvent = new FetcherEvent(this, urlStr, eventType, feed);
        Set set = this.fetcherEventListeners;
        synchronized (set) {
            Iterator iter = this.fetcherEventListeners.iterator();
            while (iter.hasNext()) {
                FetcherListener fetcherEventListener = (FetcherListener)iter.next();
                fetcherEventListener.fetcherEvent(fetcherEvent);
            }
        }
    }

    public void addFetcherEventListener(FetcherListener listener) {
        if (listener != null) {
            this.fetcherEventListeners.add(listener);
        }
    }

    public void removeFetcherEventListener(FetcherListener listener) {
        if (listener != null) {
            this.fetcherEventListeners.remove(listener);
        }
    }

    public synchronized boolean isUsingDeltaEncoding() {
        return this.usingDeltaEncoding;
    }

    public synchronized void setUsingDeltaEncoding(boolean useDeltaEncoding) {
        this.usingDeltaEncoding = useDeltaEncoding;
    }

    protected void handleErrorCodes(int responseCode) throws FetcherException {
        if (responseCode == 403) {
            this.throwAuthenticationError(responseCode);
        } else if (responseCode >= 400 && responseCode < 500) {
            this.throw4XXError(responseCode);
        } else if (responseCode >= 500 && responseCode < 600) {
            throw new FetcherException(responseCode, "The server encounted an error. HTTP Response code was:" + responseCode);
        }
    }

    protected void throw4XXError(int responseCode) throws FetcherException {
        throw new FetcherException(responseCode, "The requested resource could not be found. HTTP Response code was:" + responseCode);
    }

    protected void throwAuthenticationError(int responseCode) throws FetcherException {
        throw new FetcherException(responseCode, "Authentication required for that resource. HTTP Response code was:" + responseCode);
    }

    public static SyndFeed combineFeeds(SyndFeed originalFeed, SyndFeed newFeed) {
        try {
            SyndFeed result = (SyndFeed)newFeed.clone();
            result.getEntries().addAll(result.getEntries().size(), originalFeed.getEntries());
            return result;
        }
        catch (CloneNotSupportedException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot clone feed");
            iae.initCause(e);
            throw iae;
        }
    }

    public boolean isPreserveWireFeed() {
        return this.preserveWireFeed;
    }

    public void setPreserveWireFeed(boolean preserveWireFeed) {
        this.preserveWireFeed = preserveWireFeed;
    }
}

