
# norootforbuild
#!BuildIgnore: post-build-checks
BuildRequires:  ant ant-nodeps ant-apache-regexp ant-trax gettext-devel unzip
Name:           open-xchange-lang
BuildArch:	noarch
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo xalan-j2
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:	6.20.7.0
%define		ox_release 14
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          I18N
License:        Creative Commons Attribution-Noncommercial-Share Alike 2.5 Generic
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        Package containing i18n helper functions
Requires:	open-xchange-gui
#

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-ja-jp
Group:          I18N
Summary:	Package containing translation for ja_JP

%description -n open-xchange-lang-ja-jp
Package containing translation for ja_JP

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-ja-jp
Group:          I18N
Summary:	Package containing translation for ja_JP
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-ja-jp
Package containing translation for ja_JP

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-pl-pl
Group:          I18N
Summary:	Package containing translation for pl_PL

%description -n open-xchange-lang-pl-pl
Package containing translation for pl_PL

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-pl-pl
Group:          I18N
Summary:	Package containing translation for pl_PL
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-pl-pl
Package containing translation for pl_PL

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-es-es
Group:          I18N
Summary:	Package containing translation for es_ES

%description -n open-xchange-lang-es-es
Package containing translation for es_ES

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-es-es
Group:          I18N
Summary:	Package containing translation for es_ES
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-es-es
Package containing translation for es_ES

Authors:
--------
    Open-Xchange


#------------------------------------------------------------------------------------------
%package -n	open-xchange-lang-nl-nl
Group:          I18N
Summary:	Package containing translation for nl_NL

%description -n open-xchange-lang-nl-nl
Package containing translation for nl_NL

Authors:
--------
    Open-Xchange

%package -n	open-xchange-gui-lang-nl-nl
Group:          I18N
Summary:	Package containing translation for nl_NL
Requires:	open-xchange-lang

%description -n open-xchange-gui-lang-nl-nl
Package containing translation for nl_NL

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-it-it
Group:          I18N
Summary:        Package containing translation for it_IT

%description -n open-xchange-lang-it-it
Package containing translation for it_IT

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-it-it
Group:          I18N
Summary:        Package containing translation for it_IT
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-it-it
Package containing translation for it_IT

Authors:
--------
    Open-Xchange


#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-zh-cn
Group:          I18N
Summary:        Package containing translation for zh_CN

%description -n open-xchange-lang-zh-cn
Package containing translation for zh_CN

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-zh-cn
Group:          I18N
Summary:        Package containing translation for zh_CN
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-zh-cn
Package containing translation for zh_CN

Authors:
--------
    Open-Xchange


#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-zh-tw
Group:          I18N
Summary:        Package containing translation for zh_TW

%description -n open-xchange-lang-zh-tw
Package containing translation for zh_TW

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-zh-tw
Group:          I18N
Summary:        Package containing translation for zh_TW
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-zh-tw
Package containing translation for zh_TW

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------
%package -n     open-xchange-lang-lv-lv
Group:          I18N
Summary:        Package containing translation for lv_LV

%description -n open-xchange-lang-lv-lv
Package containing translation for lv_LV

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-lv-lv
Group:          I18N
Summary:        Package containing translation for lv_LV
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-lv-lv
Package containing translation for lv_LV

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------

%package -n     open-xchange-lang-hu-hu
Group:          I18N
Summary:        Package containing translation for hu_HU

%description -n open-xchange-lang-hu-hu
Package containing translation for hu_HU

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-hu-hu
Group:          I18N
Summary:        Package containing translation for hu_HU
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-hu-hu
Package containing translation for hu_HU

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------

%package -n     open-xchange-lang-cs-cz
Group:          I18N
Summary:        Package containing translation for cs_CZ

%description -n open-xchange-lang-cs-cz
Package containing translation for cs_CZ

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-cs-cz
Group:          I18N
Summary:        Package containing translation for cs_CZ
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-cs-cz
Package containing translation for cs_CZ

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------

%package -n     open-xchange-lang-sk-sk
Group:          I18N
Summary:        Package containing translation for sk_SK

%description -n open-xchange-lang-sk-sk
Package containing translation for sk_SK

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-sk-sk
Group:          I18N
Summary:        Package containing translation for sk_SK
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-sk-sk
Package containing translation for sk_SK

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------

%package -n     open-xchange-lang-fr-ca
Group:          I18N
Summary:        Package containing translation for fr_CA

%description -n open-xchange-lang-fr-ca
Package containing translation for fr_CA

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-fr-ca
Group:          I18N
Summary:        Package containing translation for fr_CA
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-fr-ca
Package containing translation for fr_CA

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------

%package -n     open-xchange-lang-ro-ro
Group:          I18N
Summary:        Package containing translation for ro_RO

%description -n open-xchange-lang-ro-ro
Package containing translation for ro_RO

Authors:
--------
    Open-Xchange

%package -n     open-xchange-gui-lang-ro-ro
Group:          I18N
Summary:        Package containing translation for ro_RO
Requires:       open-xchange-lang

%description -n open-xchange-gui-lang-ro-ro
Package containing translation for ro_RO

Authors:
--------
    Open-Xchange

#------------------------------------------------------------------------------------------




%description

Package containing i18n helper functions

Authors:
--------
    Open-Xchange

%prep
%setup -q -n %{name}-%{version}

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html
%else
%define docroot /srv/www/htdocs
%endif
mkdir -p %{buildroot}/opt/open-xchange/etc/i18n.d
mkdir -p %{buildroot}/opt/open-xchange/i18n
mkdir -p %{buildroot}/%{docroot}/ox6/lang
mkdir -p %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/
install -m 644 etc/i18nfunctions.sh %{buildroot}/opt/open-xchange/etc/i18nfunctions.sh
export ANT_OPTS="-Dfile.encoding=UTF-8"
ant gui-lang
for lang in es_ES nl_NL pl_PL ja_JP it_IT zh_CN zh_TW lv_LV hu_HU cs_CZ sk_SK fr_CA ro_RO; do
	DLANG=$(tr '[[:upper:]]' '[[:lower:]]' <<< ${lang/*_})
	TLANG=${lang/_*}
	test -e $lang/lang.name && \
		install -m 644 $lang/lang.name %{buildroot}/opt/open-xchange/etc/i18n.d/$lang.name
	test -e $lang/server.${lang}.po && \
		install -m 644 $lang/server.${lang}.po \
		%{buildroot}/opt/open-xchange/i18n/server.${lang}.po
	test -e lang/${lang}.js && \
		install -m 644 lang/${lang}.js \
		%{buildroot}/%{docroot}/ox6/lang/${lang}.js
	test -e $lang/tinymce_lang_pack.${lang}.zip && \
		unzip $lang/tinymce_lang_pack.${lang}.zip \
			-d %{buildroot}/%{docroot}/ox6/3rdparty/tinymce/jscripts/tiny_mce/ && \
	find %{buildroot}/%{docroot}/ox6/3rdparty/tinymce -type f -name "*${TLANG}*.js" \
		-printf '"%p"\n' > filelist_${DLANG} && \
		perl -pi -e 's;%{buildroot}/;;' filelist_${DLANG}
done


%clean
%{__rm} -rf %{buildroot}

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-ja-jp
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ja_JP || true

%postun -n open-xchange-gui-lang-ja-jp
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ja_JP || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-pl-pl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang pl_PL || true

%postun -n open-xchange-gui-lang-pl-pl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang pl_PL || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-es-es
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang es_ES || true

%postun -n open-xchange-gui-lang-es-es
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang es_ES || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-nl-nl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang nl_NL || true

%postun -n open-xchange-gui-lang-nl-nl
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang nl_NL || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-it-it
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang it_IT || true

%postun -n open-xchange-gui-lang-it-it
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang it_IT || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-zh-cn
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang zh_CN || true

%postun -n open-xchange-gui-lang-zh-cn
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang zh_CN || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-zh-tw
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang zh_TW || true

%postun -n open-xchange-gui-lang-zh-tw
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang zh_TW || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-lv-lv
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang lv_LV || true

%postun -n open-xchange-gui-lang-lv-lv
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang lv_LV || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-hu-hu
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang hu_HU || true

%postun -n open-xchange-gui-lang-hu-hu
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang hu_HU || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-cs-cz
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang cs_CZ || true

%postun -n open-xchange-gui-lang-cs-cz
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang cs_CZ || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-sk-sk
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang sk_SK || true

%postun -n open-xchange-gui-lang-sk-sk
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang sk_SK || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-fr-ca
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang fr_CA || true

%postun -n open-xchange-gui-lang-fr-ca
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang fr_CA || true

#------------------------------------------------------------------------------------------
%post -n open-xchange-gui-lang-ro-ro
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 1 && addLang ro_RO || true

%postun -n open-xchange-gui-lang-ro-ro
. /opt/open-xchange/etc/i18nfunctions.sh
test ${1:-0} -eq 0 && removeLang ro_RO || true



%files
%defattr(-,root,root)
%dir /opt/open-xchange/etc
%dir /opt/open-xchange/etc/i18n.d
/opt/open-xchange/etc/i18nfunctions.sh
%doc ChangeLog

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-ja-jp
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.ja_JP.po

%files -n open-xchange-gui-lang-ja-jp -f filelist_jp
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ja_JP.js
/opt/open-xchange/etc/i18n.d/ja_JP.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-pl-pl
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.pl_PL.po

%files -n open-xchange-gui-lang-pl-pl -f filelist_pl
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/pl_PL.js
/opt/open-xchange/etc/i18n.d/pl_PL.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-es-es
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.es_ES.po

%files -n open-xchange-gui-lang-es-es -f filelist_es
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/es_ES.js
/opt/open-xchange/etc/i18n.d/es_ES.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-nl-nl
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.nl_NL.po

%files -n open-xchange-gui-lang-nl-nl -f filelist_nl
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/nl_NL.js
/opt/open-xchange/etc/i18n.d/nl_NL.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-it-it
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.it_IT.po

%files -n open-xchange-gui-lang-it-it -f filelist_it
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/it_IT.js
/opt/open-xchange/etc/i18n.d/it_IT.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-zh-cn
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.zh_CN.po

%files -n open-xchange-gui-lang-zh-cn -f filelist_cn
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/zh_CN.js
/opt/open-xchange/etc/i18n.d/zh_CN.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-zh-tw
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.zh_TW.po

%files -n open-xchange-gui-lang-zh-tw -f filelist_tw
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/zh_TW.js
/opt/open-xchange/etc/i18n.d/zh_TW.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-lv-lv
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.lv_LV.po

%files -n open-xchange-gui-lang-lv-lv -f filelist_lv
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/lv_LV.js
/opt/open-xchange/etc/i18n.d/lv_LV.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-hu-hu
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.hu_HU.po

%files -n open-xchange-gui-lang-hu-hu -f filelist_hu
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/hu_HU.js
/opt/open-xchange/etc/i18n.d/hu_HU.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-cs-cz
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.cs_CZ.po

%files -n open-xchange-gui-lang-cs-cz -f filelist_cz
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/cs_CZ.js
/opt/open-xchange/etc/i18n.d/cs_CZ.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-sk-sk
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.sk_SK.po

%files -n open-xchange-gui-lang-sk-sk -f filelist_sk
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/sk_SK.js
/opt/open-xchange/etc/i18n.d/sk_SK.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-fr-ca
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.fr_CA.po

%files -n open-xchange-gui-lang-fr-ca
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/fr_CA.js
/opt/open-xchange/etc/i18n.d/fr_CA.name

#------------------------------------------------------------------------------------------
%files -n open-xchange-lang-ro-ro
%defattr(-,root,root)
%dir /opt/open-xchange/i18n
/opt/open-xchange/i18n/server.ro_RO.po

%files -n open-xchange-gui-lang-ro-ro -f filelist_ro
%defattr(-,root,root)
%dir %{docroot}/ox6/lang
%{docroot}/ox6/lang/ro_RO.js
/opt/open-xchange/etc/i18n.d/ro_RO.name


%changelog
* Fri Aug 10 2012 - choeger@open-xchange.com
 - fixed bug #22765 : installing open-xchange-gui-lang-fr-ca results in an
   error because fr_dlg.js for tinymce is already provided by open-xchange-gui
* Mon Jul 23 2012 - wolfgang.rosenauer@open-xchange.com
 - Fixed bug #22634 : tiny_mce translations are not unpacked to the correct location
* Thu Mar 08 2012 - viktor.pracht@open-xchange.com
  - Fixed bug #21703 : Can't login with GUI language set to cs_CZ
* Wed Feb 29 2012 - choeger@open-xchange.com
 - 21667 - [L3] errors not translated for language it_IT
* Mon Nov 15 2010 - viktor.pracht@open-xchange.com
  - TA5365 for US5198: Re-order contact address fields for Japan
* Mon Sep 14 2009 - choeger@open-xchange.com
 - Bugfix #14499 -  Dutch and Spanish cannot be selected at the UI after
   installing the corresponding language packs
