package com.openexchange.file.storage;

import com.openexchange.session.Session;

public interface FileStorageServiceFactory {

	FileStorageAccountAccess getAccountAccess(String accountId, Session session);

	FileStorageAccountManager getAccountManager();

	FileStorageFileAccess getFileAccess(Session session, String accountId);

	FileStorageFolderAccess getFolderAccess(Session session, String accountId);

	FileStorageService getFileStorageService();
	
	<S extends Object> S getService(final Class<? extends S> clazz);

	<S extends Object> S getOptionalService(Class<? extends S> clazz);

}
