package com.openexchange.file.storage;

import java.util.Collections;
import java.util.Set;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.session.Session;

public abstract class AbstractFileStorageService implements FileStorageService {
	
	private FileStorageServiceFactory factory;
	
	public AbstractFileStorageService(FileStorageServiceFactory factory) {
		this.factory = factory;
	}

	public Set<String> getSecretProperties() {
		return Collections.emptySet();
	}

	public FileStorageAccountManager getAccountManager()
			throws FileStorageException {
		return factory.getAccountManager();
	}

	public FileStorageAccountAccess getAccountAccess(String accountId,
			Session session) throws FileStorageException {
		return factory.getAccountAccess(accountId, session);
	}

}
