package com.openexchange.file.storage;

import com.openexchange.file.storage.Quota.Type;

public abstract class AbstractFileStorageFolderAccess implements FileStorageFolderAccess {


	public String deleteFolder(String folderId) throws FileStorageException {
		return deleteFolder(folderId, true);
	}

	public void clearFolder(String folderId) throws FileStorageException {
		clearFolder(folderId, true);
	}

	public Quota getStorageQuota(String folderId) throws FileStorageException {
		return Quota.getUnlimitedQuota(Type.STORAGE);
	}

	public Quota getFileQuota(String folderId) throws FileStorageException {
		return Quota.getUnlimitedQuota(Type.FILE);
	}

	public Quota[] getQuotas(String folder, Type[] types)
			throws FileStorageException {
		return Quota.getUnlimitedQuotas(types);
	}

}
