package com.openexchange.file.storage;

import com.openexchange.session.Session;

public abstract class AbstractFileStorageAccountAccess implements
		FileStorageAccountAccess {

	protected boolean connected = false;
	protected Session session;
	protected String accountId;
	protected FileStorageServiceFactory factory;
	
	public AbstractFileStorageAccountAccess(FileStorageServiceFactory factory, Session session, String accountId) {
		this.session = session;
		this.accountId = accountId;
		this.factory = factory;
	}
	
	public void connect() throws FileStorageException {
		connected = true;
	}

	public boolean isConnected() {
		return false;
	}

	public void close() {
		connected = false;
	}

	public boolean ping() throws FileStorageException {
		return true;
	}

	public boolean cacheable() {
		return true;
	}

	public String getAccountId() {
		return accountId;
	}
	
	public Session getSession() {
		return session;
	}

	public FileStorageFileAccess getFileAccess() throws FileStorageException {
		return factory.getFileAccess(session, accountId);
	}

	public FileStorageFolderAccess getFolderAccess()
			throws FileStorageException {
		return factory.getFolderAccess(session, accountId);
	}

	public FileStorageFolder getRootFolder() throws FileStorageException {
		return getFolderAccess().getRootFolder();
	}

	public FileStorageService getService() {
		return factory.getFileStorageService();
	}

}
