

package com.openexchange.custom.parallels.impl;

import com.openexchange.groupware.AbstractOXException;
import com.openexchange.groupware.EnumComponent;

/**
 * {@link ParallelsOpenApiServletException}
 * 
 * 
 */
public final class ParallelsOpenApiServletException extends AbstractOXException {




    private static final long serialVersionUID = -1061507915758721801L;

    public static enum Code {

        /**
         * A openapi  interface error occurred. action: \"%1$s\" ,response: \"%2$s\"
         */
        OPENAPI_COMMUNICATION_ERROR("An OpenAPI interface error occurred. action: \"%1$s\" ,response: \"%2$s\" " , Category.CODE_ERROR, 1),

        HTTP_COMMUNICATION_ERROR("OpenAPI communication error detected. Details: \"%1$s\"" , Category.CODE_ERROR, 1);



        private final String message;

        private final int detailNumber;

        private final Category category;

        private Code(final String message, final Category category, final int detailNumber) {
            this.message = message;
            this.detailNumber = detailNumber;
            this.category = category;
        }

        public Category getCategory() {
            return category;
        }

        public int getNumber() {
            return detailNumber;
        }

        public String getMessage() {
            return message;
        }
    }

    private static final Object[] EMPTY_ARGS = new Object[0];

    /**
     * Initializes a new {@link ParallelsOpenApiServletException}
     * 
     * @param cause The cause
     */
    public ParallelsOpenApiServletException(final AbstractOXException cause) {
        super(cause);
    }

    /**
     * Initializes a new {@link ParallelsOpenApiServletException}
     * 
     * @param code The service error code
     */
    public ParallelsOpenApiServletException(final Code code) {
        this(code, null, EMPTY_ARGS);
    }

    /**
     * Initializes a new {@link ParallelsOpenApiServletException}
     * 
     * @param code The service error code
     * @param messageArgs The message arguments
     */
    public ParallelsOpenApiServletException(final Code code, final Object... messageArgs) {
        this(code, null, messageArgs);
    }

    /**
     * Initializes a new {@link ParallelsOpenApiServletException}
     * 
     * @param code The service error code
     * @param cause The init cause
     * @param messageArgs The message arguments
     */
    public ParallelsOpenApiServletException(final Code code, final Throwable cause, final Object... messageArgs) {
        super(EnumComponent.RESOURCE, code.getCategory(), code.getNumber(), code.getMessage(), cause);
        super.setMessageArgs(messageArgs);
    }
}
