package com.openexchange.contact.aggregator.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.contact.aggregator.AggregatingSubscribeService;
import com.openexchange.contact.aggregator.ContactAggregator;
import com.openexchange.contact.aggregator.ContactFolderContactSourceFactory;
import com.openexchange.contact.aggregator.EMailFolderContactSource;
import com.openexchange.contact.aggregator.MailFolderDiscoverer;
import com.openexchange.contact.aggregator.loginHandlers.AggregatedContactFolderLoginHandler;
import com.openexchange.database.DatabaseService;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.server.osgiservice.HousekeepingActivator;
import com.openexchange.subscribe.SubscriptionExecutionService;

public class Activator extends HousekeepingActivator {

    private static final Class[] NEEDED = {FolderService.class, ConfigurationService.class, ConfigViewFactory.class, DatabaseService.class, SubscriptionExecutionService.class};
    
    @Override
    protected Class<?>[] getNeededServices() {        
        return NEEDED;
    }

    @Override
    protected void startBundle() throws Exception {
        FolderService folders = getService(FolderService.class);
        ConfigurationService config = getService(ConfigurationService.class);
        ConfigViewFactory configs = getService(ConfigViewFactory.class);
        DatabaseService databaseService = getService(DatabaseService.class);
        SubscriptionExecutionService executor = getService(SubscriptionExecutionService.class);
        
        MailFolderDiscoverer mailFolderDiscoverer = new MailFolderDiscoverer(folders);
        
        ContactAggregator aggregator = new ContactAggregator();
        aggregator.setConfigViews(configs);
        aggregator.add(new ContactFolderContactSourceFactory(configs));
        aggregator.add(new EMailFolderContactSource(mailFolderDiscoverer, config.getIntProperty("com.openexchange.contact.aggregator.mailLimit", 3000)));
        
        AggregatingSubscribeService subscribeService = new AggregatingSubscribeService(aggregator);
        
        //registerService(SubscribeService.class, subscribeService);
        registerService(LoginHandlerService.class, new AggregatedContactFolderLoginHandler(configs, databaseService, subscribeService, executor));
        
    }

	

}
