/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2011 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.axis2.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.Constants;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.AxisService;


public class ListServicesServlet extends HttpServlet {

    private static final org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory.getLog(ListServicesServlet.class);

    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";

    protected transient ServletConfig servletConfig;

    protected transient ConfigurationContext configContext;

    private boolean initCalled = false;

    private static final long serialVersionUID = 8579149968780878131L;

    public ListServicesServlet() {
    }

    public void init() throws ServletException {
        if (this.servletConfig != null
                &&
                !initCalled) {
            init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext =
                    ConfigurationContextFactory
                            .createConfigurationContext(new WarBasedAxisConfigurator(config));
            configContext.setProperty(Constants.CONTAINER_MANAGED, Constants.VALUE_TRUE);
            return configContext;
        } catch (Exception e) {
            LOG.error(e);
            throw new ServletException(e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        // prevent this method from being called more than once per instance
        initCalled = true;
        super.init(config);
        try {
            this.servletConfig = config;
            ServletContext servletContext = servletConfig.getServletContext();
            this.configContext =
                    (ConfigurationContext) servletContext.getAttribute(CONFIGURATION_CONTEXT);
            if(configContext == null){
                configContext = initConfigContext(config);
                config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, configContext);
            }
        } catch (Exception e) {
            throw new ServletException(e);
        }
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, AxisService> services = configContext.getAxisConfiguration().getServices();

        resp.setContentType("text/html");
        PrintWriter pw = resp.getWriter();
        final String welcome = "Welcome to the Open-Xchange Axis2 Service";
        pw.print("<html><title>" + welcome + "</title>");
        pw.print("<body>");
        pw.print("<h1>" + welcome + "</h1>");
        pw.print("The Open-Xchange Axis2 service has been successfully installed. It is used to provide" +
        		" Open-Xchange provisioning via SOAP. Please check" +
        		" <a href=http://oxpedia.org/wiki/index.php?title=Open-Xchange_Provisioning_using_SOAP>" +
        		"http://oxpedia.org/wiki/index.php?title=Open-Xchange_Provisioning_using_SOAP</a>" +
        		" for information on Open-Xchange provisioning using SOAP.");
        pw.print("<h2>List of currently installed services</h2>");
        if (services != null && !services.isEmpty()) {
            Collection<AxisService> servicecol = services.values();
            for (Iterator<AxisService> iterator = servicecol.iterator(); iterator.hasNext();) {
                AxisService axisService = (AxisService) iterator.next();
                final String serviceName = axisService.getName();
                final String serviceURL = req.getScheme() + "://" + req.getServerName() + req.getRequestURI() + "/services/" + serviceName + "?wsdl"; 
                pw.print("<a href=" + serviceURL + ">" + serviceURL + "</a></br>");
            }
        }
        pw.print("</body></html>");
        resp.setStatus(HttpServletResponse.SC_OK);
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doGet(req, resp);
    }

}
