/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.admin.user.copy.osgi;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.admin.daemons.AdminDaemon;
import com.openexchange.admin.rmi.exceptions.StorageException;
import com.openexchange.admin.user.copy.rmi.OXUserCopyInterface;
import com.openexchange.admin.user.copy.rmi.impl.OXUserCopy;
import com.openexchange.user.copy.UserCopyService;

/**
 * Registers the RMI user copy interface.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class RMIUserCopyRegisterer implements ServiceTrackerCustomizer {

    private static final Log LOG = LogFactory.getLog(RMIUserCopyRegisterer.class);

    private final BundleContext context;

    private static Registry registry;
    
    private static OXUserCopy userCopy;
    

    public RMIUserCopyRegisterer(BundleContext context) {
        super();
        this.context = context;
    }

    public Object addingService(final ServiceReference reference) {
        UserCopyService service = (UserCopyService) context.getService(reference);
        try {
            registry = AdminDaemon.getRegistry();

            userCopy = new OXUserCopy(context, service);
            final OXUserCopyInterface oxresell_stub = (OXUserCopyInterface) UnicastRemoteObject.exportObject(userCopy, 0);

            // bind all NEW Objects to registry
            registry.bind(OXUserCopyInterface.RMI_NAME, oxresell_stub);
            LOG.info("RMI Interface for usercopy bundle bound to RMI registry");
        } catch (final RemoteException e) {
            LOG.error(e.getMessage(), e);
        } catch (final AlreadyBoundException e) {
            LOG.error(e.getMessage(), e);
        } catch (final StorageException e) {
            LOG.error(e.getMessage(), e);
        }
        return service;
    }

    public void modifiedService(final ServiceReference reference, final Object service) {
        // Nothing to do.
    }

    public void removedService(final ServiceReference reference, final Object service) {
        try {
            if (null != registry) {
                LOG.info("RMI Interface for usercopy bundle removed from RMI registry");
                registry.unbind(OXUserCopyInterface.RMI_NAME);
                context.ungetService(reference);
            }
        } catch (final AccessException e) {
            LOG.error(e.getMessage(), e);
        } catch (final RemoteException e) {
            LOG.error(e.getMessage(), e);
        } catch (final NotBoundException e) {
            LOG.error(e.getMessage(), e);
        }
    }
}
