/*
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com
 */
 
new ox.Configuration.InnerNode("configuration/user", _("User"));
  
var node = new ox.Configuration.LeafNode("configuration/user/password",
                                         _("Password"));
var page = new ox.Configuration.Page(node, _("Change Password"));
 
var intro = new ox.UI.Text(_("Choose a new password for your account."));
page.addWidget(intro);
 
var pass_old = new ox.UI.Password(_("Your old password"));
page.addWidget(pass_old, "old_password");
 
var pass_new = new ox.UI.Password(_("The new password"));
page.addWidget(pass_new, "new_password");
 
var pass_new2 = new ox.UI.Password(_("Confirm new password"));
page.addWidget(pass_new2, "new_password2");

page.save = function (data, cont) {
	function emptyPass() {
		ox.Configuration.error(_("Please enter your old password and twice the new password."));		
	}
	if (pass_old.get() == "") {
		pass_old.formnode.focus();
		return emptyPass();
	} else if (pass_new.get() == "") {
		pass_new.formnode.focus();
		return emptyPass();
	} else if (pass_new2.get() == "") {
		pass_new2.formnode.focus();
		return emptyPass();
	} else if (pass_new.get() != pass_new2.get()) {
		pass_new.formnode.focus();
		ox.Configuration.error(_("The two newly entered passwords do not match."));
		return;
	}

	ox.JSON.put(AjaxRoot+"/passwordchange?action=update&session="+session,data,
        function() {
            ox.Configuration.info(
                _("Your new password has been saved."));
            cont();
        });
}