/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

ox.gui.initToolBarPortal = function ($p) {

    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var sections = ox.widgets.toolBar.sections;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.portal = new ox.gui.TabMenu(
        $p.getOptions({
            id: "toolbar-portal",
            showSectionNames: false,
            inHover: true
        })
    );
    
    // new
    tab = tabs.portalCreate = new ox.gui.PanelMenu(
        "toolbar-portal-create", _("&New")).addTo(toolbar);
    section = sections.portalCreate = new ox.gui.PanelMenuSection(_("New"), "portalCreateSection").addTo(tab);
    add(section, ox.widgets.toolBar.meta.create, "portal-create",
        ["mail", "calendar", "contact", "distributionlist", "task", "file"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    // first tab is default
    ox.ToolBarController.setDefaultTab(toolbar, 0);
};