/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/mail/preferences",
	function () { 
		showNode("config_mail"); 
		$("config_mail").style.display="block";
        
        // toolbar
        temporary.configuration.showToolbar(
            temporary.configuration.defaultToolbar);
	},
	function() {
		register("OX_SAVE_OBJECT",cm_saveConfiguration);
		register("OX_Cancel_Object",cm_cancelConfiguration);
		cm_enter();
        changeTab('contentMailConfigCommon', 'tabMailConfigCommon');
        $("tabMailConfigCommon").className="tabPanelFirstHi tabPanelHiColor background-color-content font-style-lable border-color-content-default";        
	},
	function() { 
		//configuration_askforSave();	
		unregister("OX_SAVE_OBJECT",cm_saveConfiguration);
		unregister("OX_Cancel_Object",cm_cancelConfiguration);
		cm_leave(); 
	},
	function () { 
		hideNode("config_mail"); 
		$("config_mail").style.display="none";
		$("tabMailConfigCommon").className="tabPanelFirst tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default";		 
	},
	function () { 
		cm_enter(); 
	}
);

function cm_saveConfiguration() {
	if (configuration_changed_fields["gui"]) {
		configSetKey("gui.mail.view", cm_default_level1.getKey());
		configSetKey("gui.mail.view_spam", cm_default_level2.getKey());
		configSetKey("gui.mail.notifyacknoledge",getBoolofInt(getValueofRadioBox("cm_notifyacknoledge")));
        configSetKey("gui.mail.showimage",getBoolofInt(getValueofRadioBox("cm_showimage")));
		configSetKey("gui.mail.formatmessage",getStringofRadioBox("cm_formatmessage"));
		configSetKey("gui.mail.autocomplete",getBoolofInt(getValueofRadioBox("cm_autocomplete")));
		configSetKey("gui.mail.auto_save_drafts", cm_auto_save_mail_drafts.getKey());
		configSetKey("gui.mail.defaul_mail_font", cm_default_mail_font.getKey());
		configSetKey("gui.mail.defaul_mail_font_size", cm_default_mail_font_size.getKey());
		configSetKey("gui.effects.hover.mail",getBoolofInt(getValueofRadioBox("cm_enablehovermail")));
		configSetKey("gui.mail.select_first_message",getBoolofInt(getValueofRadioBox("cm_emailSelectFirstMessage")));
		configSetKey("gui.mail.editor_featureset", cm_editor_featureset.getKey());
		configSetKey("gui.mail.showname", getBoolofInt(getValueofRadioBox("cm_showname")));
	}
	if (configuration_changed_fields["mail"]) {
		configSetKey("mail.vcard",getBoolofInt(getValueofRadioBox("cm_appendvcard")));		
		configSetKey("mail.deletemail",getBoolofInt(getValueofRadioBox("cm_deletemail")));
		configSetKey("mail.appendmailtext",getBoolofInt(getValueofRadioBox("cm_appendmailtext")));
		configSetKey("mail.inlineattachments",getBoolofInt(getValueofRadioBox("cm_inlineattachments")));
		configSetKey("mail.colorquoted",getBoolofInt(getValueofRadioBox("cm_colorquoted")));
		configSetKey("mail.emoticons",getBoolofInt(getValueofRadioBox("cm_emoticons")));
		configSetKey("mail.forwardmessage",getStringofRadioBox("cm_forwardmessage"));
		configSetKey("mail.linewrap",$("cm_linewrap").value);
		configSetKey("mail.sendaddress", cm_default_sendaddress.getKey());
	}
	if (configuration_changed_fields["modules"]) {
		configSetKey("modules.mail.allowhtmlimages", getBoolofInt(getValueofRadioBox("cm_preloadimages")));
		if (configContainsKey("modules.mail.contactCollectEnabled") && configContainsKey("modules.mail.contactCollectFolder")) {			
			configSetKey("modules.mail.contactCollectOnMailTransport", getBoolofInt(getValueofRadioBox("cm_contactCollectOnMailTransport")));
			configSetKey("modules.mail.contactCollectOnMailAccess", getBoolofInt(getValueofRadioBox("cm_contactCollectOnMailAccess")));
		}
		configSetKey("modules.mail.replyallcc", getBoolofInt(getValueofRadioBox("cm_replyallcc")));
	}
	
	triggerEvent("OX_Save_Configuration",false,false);
}

function cm_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	configuration_changed_fields["mail"]=false;
	configuration_changed_fields["modules"]=false;
	cm_enter();	
}

var cm_default_level1, cm_default_level2;
var cm_default_sendaddress, cm_auto_save_mail_drafts, cm_default_mail_font, cm_default_mail_font_size, cm_editor_featureset;
var cm_init_bool=false;

register("OX_Configuration_Loaded",cm_onconfigload);
function cm_onconfigload() {
    addDefaultView("mail/list/unthreaded", _("List view"));
    addDefaultView("mail/hsplit/unthreaded", _("H-split view"));
    addDefaultView("mail/vsplit/unthreaded", _("V-split view"));
}

function cm_leave() { }

function cm_enter() {
	if(!cm_init_bool) {
		cm_init();
		cm_init_bool=true;
	}
	if(configContainsKey("gui.mail.view")) {
		cm_default_level1.setKey(configGetKey("gui.mail.view"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.view_spam")) {
		cm_default_level2.setKey(configGetKey("gui.mail.view_spam"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("gui.mail.select_first_message")) {
        setValueofRadioBox("cm_emailSelectFirstMessage",configGetKey("gui.mail.select_first_message"));
        configuration_changed_fields["gui"]=false;
    }
	if(configContainsKey("mail.deletemail")) {
		setValueofRadioBox("cm_deletemail",configGetKey("mail.deletemail"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("gui.mail.notifyacknoledge")) {
		setValueofRadioBox("cm_notifyacknoledge",configGetKey("gui.mail.notifyacknoledge"));
		configuration_changed_fields["gui"]=false;
	}
    if(configContainsKey("gui.mail.showimage")) {
        setValueofRadioBox("cm_showimage",configGetKey("gui.mail.showimage"));
        configuration_changed_fields["gui"]=false;
    }
	if(configContainsKey("mail.appendmailtext")) {
		setValueofRadioBox("cm_appendmailtext",configGetKey("mail.appendmailtext"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.inlineattachments")) {
		setValueofRadioBox("cm_inlineattachments",configGetKey("mail.inlineattachments"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.vcard")) {
		setValueofRadioBox("cm_appendvcard",configGetKey("mail.vcard"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("gui.mail.autocomplete")) {
		setValueofRadioBox("cm_autocomplete",configGetKey("gui.mail.autocomplete"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("mail.colorquoted")) {
		setValueofRadioBox("cm_colorquoted",configGetKey("mail.colorquoted"));
		configuration_changed_fields["mail"]=false;
	}
    if(configContainsKey("mail.emoticons")) {
        setValueofRadioBox("cm_emoticons",configGetKey("mail.emoticons"));
        configuration_changed_fields["mail"]=false;
    }
	if (configContainsKey("gui.mail.showname")) {
		setValueofRadioBox("cm_showname", configGetKey("gui.mail.showname"));
		configuration_changed_fields.mail = false;
	}
	if(configContainsKey("gui.mail.formatmessage")) {
		setStringofRadioBox("cm_formatmessage",configGetKey("gui.mail.formatmessage"));
		configuration_changed_fields["gui"]=false;
	}	
	if(configContainsKey("gui.mail.defaul_mail_font")) {
		cm_default_mail_font.setKey(configGetKey("gui.mail.defaul_mail_font"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.defaul_mail_font_size")) {
		cm_default_mail_font_size.setKey(configGetKey("gui.mail.defaul_mail_font_size"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.editor_featureset")) {
		cm_editor_featureset.setKey(configGetKey("gui.mail.editor_featureset"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.mail.auto_save_drafts")) {
		cm_auto_save_mail_drafts.setKey(configGetKey("gui.mail.auto_save_drafts"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("mail.forwardmessage")) {
		setStringofRadioBox("cm_forwardmessage",configGetKey("mail.forwardmessage"));
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.linewrap")) {
		$("cm_linewrap").value=configGetKey("mail.linewrap");
		configuration_changed_fields["mail"]=false;
	}
	if(configContainsKey("mail.sendaddress")) {
		cm_default_sendaddress.setKey(configGetKey("mail.sendaddress"));
		configuration_changed_fields["mail"]=false;
	}	
	if(configContainsKey("gui.effects.hover.mail")) {
		setIntofRadioBox("cm_enablehovermail",configGetKey("gui.effects.hover.mail"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("modules.mail.allowhtmlimages")) {
		setIntofRadioBox("cm_preloadimages",configGetKey("modules.mail.allowhtmlimages"));
		configuration_changed_fields["modules"]=false;
	}
	var emailCollectEnabled = false;
    if (   configContainsKey("modules.mail.contactCollectOnMailTransport")
        && configContainsKey("modules.mail.contactCollectOnMailAccess"))
    {
        setIntofRadioBox("cm_contactCollectOnMailTransport", configGetKey("modules.mail.contactCollectOnMailTransport"));
        setIntofRadioBox("cm_contactCollectOnMailAccess", configGetKey("modules.mail.contactCollectOnMailAccess"));
        configuration_changed_fields["modules"]=false;        
        if (   configContainsKey("modules.mail.contactCollectFolder")
            && configGetKey("modules.mail.contactCollectFolder") != 0)
        {
            ox.api.folder.get({
                folder: configGetKey("modules.mail.contactCollectFolder"),
                success: function (data) { 
                    //#. %s is the folder name.
                    //#, c-format
                    $("cm_emailCollection_text").firstChild.nodeValue = format(
                        _("Automatically collect contacts in the folder \"%s\""),
                        [data.title]);
                }
            });
        } else {
            $("cm_emailCollection_text").firstChild.nodeValue =
                _("Automatically collect contacts");
        }
        emailCollectEnabled=true;        
    }
	$("cm_emailCollectionContent0").style.display=emailCollectEnabled ? "" : "none";
	$("cm_emailCollectionContent1").style.display=emailCollectEnabled ? "" : "none";
	$("cm_emailCollectionContent2").style.display=emailCollectEnabled ? "" : "none";

    if(configContainsKey("modules.mail.replyallcc")) {
        setIntofRadioBox("cm_replyallcc",configGetKey("modules.mail.replyallcc"));
        configuration_changed_fields["gui"]=false;
    }
	setConfigPath($("cm_header"));	
	
	// register tabs
	setTabLists(new Array('contentMailConfigCommon','contentMailConfigCompose','contentMailConfigDisplay'),
		new Array('tabMailConfigCommon','tabMailConfigCompose','tabMailConfigDisplay'), null);	
}

function cm_init() {
	cm_default_level1= new ComboBox3(window, "cm_default_level1", "20em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	var mailviews=getDefaultSubviews("mail");
	for (var i in mailviews) {
		cm_default_level1.addElement(mailviews[i],i);
	}
	cm_default_level1.getDomNode();
	
	cm_default_level2= new ComboBox3(window, "cm_default_level2", "20em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	for (var i in mailviews) {
		cm_default_level2.addElement(mailviews[i],i);
	}
	cm_default_level2.getDomNode();	
	$("cm_default_level2_parent").style.display = configGetKey("mail.folder.spam") ? "" : "none";
	
	cm_default_sendaddress= new ComboBox3(window, "cm_default_sendaddress", "30em", 0, true,"OX_Configuration_Settings_Changed_Mail", 3);
	var aliases = configContainsKey("mail.addresses") ? configGetKey("mail.addresses") : new Array();
	for (a=0; a < aliases.length; a++) {
        cm_default_sendaddress.addElement(noI18n(aliases[a]), aliases[a]);
	}
	cm_default_sendaddress.getDomNode();
	
	// pre-fill with default parameter if not set in config
	if (!configContainsKey("gui.mail.auto_save_drafts"))
		configSetKey("gui.mail.auto_save_drafts",5);
	
	var myarray=[60000,180000,300000,600000,900000,1800000];
	cm_auto_save_mail_drafts = new ComboBox3(window, "cm_auto_save_mail_drafts", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
    cm_auto_save_mail_drafts.addElement(_("Disabled"), 0);
	for(var i=0;i<myarray.length;i++) {
		if(!myarray[i]== 0) {
            cm_auto_save_mail_drafts.addElement(getInterval(myarray[i]),
                                                myarray[i] / 60000);
		}
	}
	cm_auto_save_mail_drafts.getDomNode();
	
	cm_default_mail_font = new ComboBox3(window, "cm_default_mail_font", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", 5);
    cm_default_mail_font.addElement(_("Default"), "default");
    cm_default_mail_font.addElement(noI18n("Andale Mono"), "andale mono,times");
    cm_default_mail_font.addElement(noI18n("Arial"), "arial,helvetica,sans-serif");
    cm_default_mail_font.addElement(noI18n("Arial Black"), "arial black,avant garde");
    cm_default_mail_font.addElement(noI18n("Book Antiqua"), "book antiqua,palatino");
    cm_default_mail_font.addElement(noI18n("Comic Sans MS"), "comic sans ms,sans-serif");
    cm_default_mail_font.addElement(noI18n("Courier New"), "courier new,courier");
    cm_default_mail_font.addElement(noI18n("Georgia"), "georgia,palatino");
    cm_default_mail_font.addElement(noI18n("Helvetica"), "helvetica");
    cm_default_mail_font.addElement(noI18n("Impact"), "impact,chicago");
    cm_default_mail_font.addElement(noI18n("Symbol"), "symbol");
    cm_default_mail_font.addElement(noI18n("Tahoma"), "tahoma,arial,helvetica,sans-serif");
    cm_default_mail_font.addElement(noI18n("Terminal"), "terminal,monaco");
    cm_default_mail_font.addElement(noI18n("Times New Roman"), "times new roman,times");
    cm_default_mail_font.addElement(noI18n("Trebuchet MS"), "trebuchet ms,geneva");
    cm_default_mail_font.addElement(noI18n("Verdana"), "verdana,geneva");
    cm_default_mail_font.addElement(noI18n("Webdings"), "webdings");
    cm_default_mail_font.addElement(noI18n("Wingdings"), "wingdings,zapf dingbats");
	cm_default_mail_font.getDomNode();
	
	cm_default_mail_font_size = new ComboBox3(window, "cm_default_mail_font_size", "6em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
    cm_default_mail_font_size.addElement(_("Default"), "default");
    cm_default_mail_font_size.addElement(noI18n("1 (8pt)"), 1);
    cm_default_mail_font_size.addElement(noI18n("2 (10pt)"), 2);
    cm_default_mail_font_size.addElement(noI18n("3 (12pt)"), 3);
    cm_default_mail_font_size.addElement(noI18n("4 (14pt)"), 4);
    cm_default_mail_font_size.addElement(noI18n("5 (18pt)"), 5);
    cm_default_mail_font_size.addElement(noI18n("6 (24pt)"), 6);
    cm_default_mail_font_size.addElement(noI18n("7 (36pt)"), 7);
	cm_default_mail_font_size.getDomNode();
	
	cm_editor_featureset = new ComboBox3(window, "cm_editor_featureset", "15em", 0, true,"OX_Configuration_Settings_Changed_GUI", 3);
	cm_editor_featureset.addElement(_("Default"),'1');
	cm_editor_featureset.addElement(_("Enhanced"),'2'); 
	cm_editor_featureset.getDomNode();
	
}

function cm_linewrap_changed() {
	var newvalue=trimStr($("cm_linewrap").value);
	if (newvalue == "")
		newvalue=0;
	newvalue=parseInt(newvalue, 10);
	if(isNaN(newvalue) || newvalue < 0) {
		newvalue=configGetKey("mail.linewrap");
	}
	$("cm_linewrap").value=newvalue;
	configuration_changed_fields["mail"]=true;
}
fileloaded();