/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/infostore/preferences",
	function () { 
		showNode("config_infostore"); 
		$("config_infostore").style.display="block";
        
        // toolbar
        temporary.configuration.showToolbar(
            temporary.configuration.defaultToolbar);
	},
	function() { 
		register("OX_SAVE_OBJECT",ci_saveConfiguration);
		register("OX_Cancel_Object",ci_cancelConfiguration);
		ci_enter(); },
	function() {
		//configuration_askforSave();
		unregister("OX_SAVE_OBJECT",ci_saveConfiguration);
		unregister("OX_Cancel_Object",ci_cancelConfiguration);
		ci_leave();
	},
	function () { 
		hideNode("config_infostore"); 
		$("config_infostore").style.display="none"; },
	function() {
		ci_enter();
	}
);

var ci_init_bool=false;
var ci_default_level1;
register("OX_Configuration_Loaded",ci_onconfigload);
function ci_onconfigload() {
    addDefaultView("infostore/list", _("List view"));
    addDefaultView("infostore/split", _("H-split view"));
}
function ci_init() {
	ci_default_level1= new ComboBox3(window, "ci_default_level1", "16em", 1, true,"OX_Configuration_GUI_Changed", 5);
	var conviews=getDefaultSubviews("infostore");
	for (var i in conviews) {
		ci_default_level1.addElement(conviews[i],i);
	}
	ci_default_level1.getDomNode();
}
function ci_enter() {
	if(!ci_init_bool) {
		ci_init();
		ci_init_bool=true;
	}
	if(configContainsKey("gui.infostore.view")) {
		ci_default_level1.setKey(configGetKey("gui.infostore.view"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.infostore")) {
		setIntofRadioBox("ci_enablehoverinfostore",configGetKey("gui.effects.hover.infostore"));
		configuration_changed_fields["gui"]=false;
	}
	setConfigPath($("ci_header"));		
		
}
function ci_saveConfiguration() {
	if(configuration_changed_fields["gui"]==true) {
		configSetKey("gui.infostore.view",ci_default_level1.getKey());
		menulastviews["infostore"]=ci_default_level1.getKey();
		configSetKey("gui.effects.hover.infostore",getBoolofInt(getValueofRadioBox("ci_enablehoverinfostore")));
	}
	triggerEvent("OX_Save_Configuration",false,false);
}
function ci_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	ci_enter();
}
function ci_leave() {
}
fileloaded();