/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2011
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

var limg = new Image();
limg.src = "themes/default/img/ox_animated_withoutbg.gif";

var match = /(\w+)([-_](\w+))?/.exec(navigator.language || navigator.userLanguage);
var lang = "en_US";
if (match) {
	if (match[2]) {
		lang = match[1].toLowerCase() + "_" + match[3].toUpperCase();
		if (!{"de_DE": true, "en_US": true, "fr_FR": true}[lang])
			lang = {de: "de_DE", en: "en_US", fr: "fr_FR"}[match[1].toLowerCase()] || "en_US";
	} else
		lang = {de: "de_DE", en: "en_US", fr: "fr_FR"}[match[1].toLowerCase()] || "en_US";
}

var i18n = { de_DE:[], en_US:[], fr_FR:[] };
function addlTag(lcode, id, val) { i18n[lcode][id]=val; }
function getlTag(lcode, id) {	return (i18n[lcode] && i18n[lcode][id] ? i18n[lcode][id] : i18n["en_US"][id]); }

addlTag("fr_FR", "t1", "<b>Information:</b><br>"
					+ "Il semble que vous n'utilisez pas le navigateur web le plus adapt&eacute; &agrave; cette application.<br>"
					+ "Un des navigateurs suivants devraient contribuer &agrave; am&eacute;liorer les performances:<br>"
					+ "<ul><li>Firefox &agrave; partir de la version 2.0 - <a href=\"http://www.firefox.com\" target=\"_blank\">www.firefox.com</a></li>"
					+ "<li>Internet Explorer 7 - <a href=\"http://www.microsoft.com/windows/downloads/\" target=\"_blank\">www.microsoft.com</a></li></ul>");
addlTag("en_US", "t1", "<b>Information:</b><br>"
					+ "It has been identified that you are not using the most optimal web browser for this application.<br>"
					+ "One of the following should help improve performance:<br>"
					+ "<ul><li>Firefox from 2.0 - <a href=\"http://www.firefox.com\" target=\"_blank\">www.firefox.com</a></li>"
					+ "<li>Internet Explorer 7 - <a href=\"http://www.microsoft.com/windows/downloads/\" target=\"_blank\">www.microsoft.com</a></li></ul>");
addlTag("de_DE", "t1", "<b>Information:</b><br>"
					+ "Sie verwenden nicht den optimalen Browser f&uuml;r diese Anwendung. "
					+ "F&uuml;r einen reibungslosen Einsatz der Applikation und zum Erzielen bestm&ouml;glicher Performance, empfehlen wir den Einsatz eines der folgenden Browser:<br>"
					+ "<ul><li>Firefox ab Version 2.0 - <a href=\"http://www.firefox.com\" target=\"_blank\">www.firefox.com</a></li>"
					+ "<li>Internet Explorer 7 - <a href=\"http://www.microsoft.com/windows/downloads/\" target=\"_blank\">www.microsoft.com</a></li></ul>");				
addlTag("en_US", "t5", "Loading Scripts and Content ... Please Wait ...");
addlTag("de_DE", "t5", "Skripte und Inhalt werden geladen... bitte warten...");
addlTag("fr_FR", "t5", "Chargement des scripts et du contenu en cours ... Veuillez patienter ...");
addlTag("en_US", "t6", "Don't show again");
addlTag("de_DE", "t6", "Nicht erneut anzeigen");
addlTag("fr_FR", "t6", "Ne plus afficher");

function testAJAX() {
	try {
		return new XMLHttpRequest();
	} catch (e) {
		try {
			return new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				return new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {
				return false;
			}
		}
	}
	return false;
}

function write(text, allow) {
	document.getElementById("browserchecktext_id").innerHTML=text;
	if (allow) {
		document.getElementById("browsercheck_okbutton").onkeydown=checkKey;
		document.getElementById("browsercheck_button").style.display="";
		document.getElementById("browser_dsagain_text").firstChild.data = getlTag(lang, "t6");
		document.getElementById("browser_dsagain").style.display="";
		document.getElementById("browser_dsagain").parentNode.style.height="2.6em";
	} else {
		document.getElementById("browser_dsagain").parentNode.style.height="1.6em";
		document.getElementById("browsercheck_button").style.display="none";
		document.getElementById("browser_dsagain").style.display="none";
	}
}

function checkKey(event) {
	if (event) {
        switch (event.keyCode || event.which) {
            case 32:
            case 13:
                redirect();
                break;                
            default:
                return false;
        }
    }
}

function redirect() {
	try {
		if (document.getElementById("bcheck1").checked == true && navigator.cookieEnabled == true) {       
	        var exp = new Date();
	        exp.setTime(exp.getTime() + 700 * 24 * 60 * 60 * 1000);         
	        document.cookie="oxbwcheck=true; expires="+exp.toGMTString();
	    }	
	} catch (e) { }
	write("<img src=\"" + limg.src + "\" width=\"25\" height=\"25\" align=\"absmiddle\"> " + getlTag(lang, "t5"));
    window.setTimeout(function() {
    	window.location = "ox.html" + window.location.search + window.location.hash; 
    }, 0);
}

function check() {
    
 	if (navigator.appName == "Microsoft Internet Explorer") {
		var version = Number(navigator.appVersion.match(/MSIE (\d+\.\d+)/)[1]);
		if (version <= 6) {
            var xml = testAJAX();
            if (xml) {
                xml.open("GET", "ie6/js/check.js", false);
                xml.send(null);
                if (xml.status == 200) {
                    window.location="ie6/";
                    return;
                }
            }
            write(getlTag(lang, "t1"), false);
		} else redirect();
    } else if (document.cookie && document.cookie.match(/oxbwcheck=true/g)) {
        redirect();
	} else if (navigator.appName == "Netscape" && navigator.userAgent.indexOf("rv:") >= 0) {
		var version = Number(navigator.userAgent.match(/rv:(\d+\.\d+)/)[1]);
		if (version < 1.8)
			write(getlTag(lang, "t1"), false);
		else redirect();
	} else if (navigator.userAgent.indexOf("AppleWebKit") >= 0) {		
        var match = navigator.userAgent.match(/(?:Version|Chrome)\/(\d+\.\d+)/);
        if (match) {
            var version = Number(match[1]);
            if (version < 3.1)
                write(getlTag(lang, "t1"), true);
            else
                redirect();
        } else
            write(getlTag(lang, "t1"), true);
    } else if (!testAJAX()) {
		write(getlTag(lang, "t1"), false);
	} else {
		write(getlTag(lang, "t1"), true);
	}
}

