/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2011 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.sessiond.event;

import java.util.Map;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondException;

/**
 * {@link SessiondEventListener} - The listener for sessiond events.
 * 
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public interface SessiondEventListener {

    /**
     * Handles the removal of specified session
     * 
     * @param session The removed session
     */
    void handleSessionRemoval(Session session);

    /**
     * Handles the removal of specified session container
     * 
     * @param sessions The removed session container
     */
    void handleContainerRemoval(Map<String, Session> sessions);

    /**
     * Handles the specified error
     * 
     * @param error The error
     */
    public void handleError(SessiondException error);

    /**
     * Implementations should remove all temporary data for those sessions because they are not used for a longer time frame and are now
     * stored in the long term session life time container. This should use as less memory as possible.
     *
     * @param sessions the sessions put into long term container.
     */
    void handleSessionDataRemoval(Map<String, Session> sessions);

    /**
     * Implementations can restore temporary session information on this event. It is emitted if a session walks from the long term life
     * time container back to the normal ones.
     *
     * @param session reactivated sessions.
     */
    void handleSessionReactivation(Session session);
}
