/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.config.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.BasicProperty;
import com.openexchange.config.cascade.ConfigCascadeException;
import com.openexchange.config.cascade.ConfigProviderService;

/**
 * {@link ConfigProviderServiceImpl}
 * 
 * @author <a href="mailto:martin.herfurth@open-xchange.com">Martin Herfurth</a>
 */
public class ConfigProviderServiceImpl implements ConfigProviderService {

    private static final String META = "meta";

    private static final String SETTINGS = "settings";

    private static final String PREFRENCE_PATH = "preferencePath";

    private static final String VALUE = "value";

    private ConfigurationService configService;
    
    private ConcurrentMap<String, ServerProperty> properties = new ConcurrentHashMap<String, ServerProperty>();

    public ConfigProviderServiceImpl(ConfigurationService configService) {
        setConfigService(configService);
    }
    
    public ServerProperty get(String property, int context, int user) {
        ServerProperty basicProperty = properties.get(property);
        if (basicProperty != null) {
            return basicProperty;
        }
        ServerProperty retval = new ServerProperty();
        String value = configService.getProperty(property);
        retval.setDefined(value != null);
        retval.set(value);
        
        ServerProperty alreadyDefined = properties.putIfAbsent(property, retval);
        if(alreadyDefined != null) {
            return alreadyDefined;
        }
        return retval;
    }

    public Collection<String> getAllPropertyNames(int context, int user) {
        Iterator<String> propertyNames = configService.propertyNames();
        Set<String> retval = new HashSet<String>();
        while (propertyNames.hasNext()) {
            retval.add(propertyNames.next());
        }
        retval.addAll(properties.keySet());
        return retval;
    }

    public void setConfigService(ConfigurationService configService) {
        this.configService = configService;
        initSettings(configService);
        initMetadata(configService);
    }

    private void initSettings(ConfigurationService config) {
        Properties propertiesInFolder = config.getPropertiesInFolder(SETTINGS);
        for(Object propName : propertiesInFolder.keySet()) {
            get((String) propName, -1, -1).set(PREFRENCE_PATH, (String) propName);
        }
        
    }

    private void initMetadata(ConfigurationService config) {
        Map<String, Object> yamlInFolder = config.getYamlInFolder(META);
        for(Object o : yamlInFolder.values()) {
            Map<String, Object> metadataDef = (Map<String, Object>) o;
            for(Map.Entry<String, Object> entry : metadataDef.entrySet()) {
                String propertyName = entry.getKey();
                Map<String, Object> metadata = (Map<String, Object>) entry.getValue();
                ServerProperty basicProperty = get(propertyName, -1, -1);
                for(Map.Entry<String, Object> metadataProp : metadata.entrySet()) {
                    if(metadataProp.getValue() != null) {
                        basicProperty.set(metadataProp.getKey(), metadataProp.getValue().toString());
                    }
                }
                
                String value = basicProperty.get(VALUE);
                if (value == null) {
                    value = config.getProperty(propertyName);
                }
                basicProperty.set(value);
                basicProperty.setDefined(value != null);    
            }
        }
    }

}
