/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;

public class Attachment {
    List attributes = new ArrayList();
    String filename;
    RawInputStream rawData;
    MAPIProps MAPIProps;
    Message nestedMessage;

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public Attr getAttribute(int ID) {
        return Attr.findAttr(this.attributes, ID);
    }

    public String getFilename() {
        if (this.filename == null) {
            try {
                Attr attr;
                this.filename = (String)this.MAPIProps.getPropValue(14087);
                if (this.filename == null) {
                    this.filename = (String)this.MAPIProps.getPropValue(14084);
                }
                if (this.filename == null && (attr = this.getAttribute(36865)) != null) {
                    this.filename = (String)attr.getValue();
                }
                if (this.filename == null && (attr = this.getAttribute(32784)) != null) {
                    this.filename = (String)attr.getValue();
                }
            }
            catch (IOException ioe) {
                this.filename = null;
            }
        }
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addAttribute(Attr attr) {
        this.attributes.add(attr);
    }

    public RawInputStream getRawData() {
        return this.rawData;
    }

    public void setRawData(RawInputStream rawData) {
        this.rawData = rawData;
    }

    public Message getNestedMessage() {
        return this.nestedMessage;
    }

    public void setNestedMessage(Message nestedMessage) {
        this.nestedMessage = nestedMessage;
    }

    public MAPIProps getMAPIProps() {
        return this.MAPIProps;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Attachment:");
        for (int i = 0; i < this.attributes.size(); ++i) {
            s.append("\n  ").append(this.attributes.get(i));
        }
        if (this.getRawData() != null) {
            s.append("\n  data=").append(this.getRawData());
        }
        if (this.getMAPIProps() != null) {
            MAPIProp[] props = this.getMAPIProps().getProps();
            s.append("\n  MAPIProps=");
            for (int i = 0; i < props.length; ++i) {
                s.append("\n    ").append(props[i]);
            }
        }
        if (this.getNestedMessage() != null) {
            s.append("\n  Nested Message:").append(this.getNestedMessage());
        }
        return s.toString();
    }

    public void setMAPIProps(MAPIProps MAPIProps2) throws IOException {
        MAPIValue value;
        MAPIProp prop;
        this.MAPIProps = MAPIProps2;
        if (MAPIProps2 != null && (prop = MAPIProps2.getProp(14081)) != null && prop.getLength() > 0 && (value = prop.getValues()[0]) != null) {
            RawInputStream data = value.getRawData();
            if (prop.getType() == 13) {
                data.readBytes(16);
            }
            this.setRawData(data);
            Object o = value.getValue();
            if (o instanceof TNEFInputStream) {
                this.setNestedMessage(new Message((TNEFInputStream)o));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(String filename) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            this.writeTo(fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        int count;
        if (this.rawData == null) {
            return;
        }
        RawInputStream in = new RawInputStream(this.rawData);
        byte[] buf = new byte[4096];
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        in.close();
    }
}

