new ox.Configuration.InnerNode("configuration/admin", _("Administration"));
var node = new ox.Configuration.LeafNode("configuration/admin/resources",
                                         _("Resources"));
var page = new ox.Configuration.VSplit(node, _("Resource Administration"), 0.5);
page.init = function() {
    var selection = new Selection();
    var defaultClear = LiveGrid.makeClear("");
    var grid = new LiveGrid([
        {
            text: _("Resource name"),
            index: "name",
            id: "name",
            sortable: true,
            width: "20%",
            clear: defaultClear,
            set: LiveGrid.defaultSet
        }, {
            text: _("Display name"),
            index: "display_name",
            id: "display_name",
            sortable: true,
            width: "20%",
            clear: defaultClear,
            set: LiveGrid.defaultSet
        }, {
            text: _("Email"),
            index: "mailaddress",
            id: "mailaddress",
            sortable: true,
            width: "20%",
            clear: defaultClear,
            set: LiveGrid.defaultSet
        }, {
            text: _("Description"),
            index: "description",
            id: "description",
            sortable: true,
            clear: defaultClear,
            set: LiveGrid.defaultSet
        }
    ], selection);
    grid.sort = LiveGrid.localSort;
    grid.emptylivegridtext = _("No resources available");
    page.list = grid;
    page.enableList = function() {
        ox.JSON.put(AjaxRoot + "/resource?action=search&session=" + session,
            { pattern: "*" }, handleSearch);
        function handleSearch(reply) {
            for (var i = 0; i < reply.data.length; i++)
                reply.data[i].timestamp = reply.timestamp;
            storage.remove(0, storage.ids.length);
            storage.append(reply.data);
            grid.enable(storage);
            grid.setSort(grid.sort_id, grid.sort_order);
        }
    };
    page.load = function(cont) {
        storage.newIterate(selection.getSelected(), emptyFunction,
            function(i, data) { cont(data); });
    };
    page.save = function(data, cont) {
        if ("id" in data) {
            var d = clone(data);
            delete d.id;
            delete d.timestamp;
            ox.JSON.put(AjaxRoot + "/resource/?action=update&id=" + data.id +
                        "&timestamp=" + data.timestamp +
                        "&session=" + session, d,
                        function(reply) {
                            data.timestamp = reply.timestamp;
                            storage.localUpdate([data.id],
                                function(old) { return data; });
                            cont(data);
                        });
        } else {
            ox.JSON.put(AjaxRoot + "/resource/?action=new&session=" + session,
                        data, function(reply) {
                            data.id = reply.data.id;
                            data.timestamp = reply.timestamp;
                            storage.append([data]);
                            cont(data);
                        });
        }
    };
    
    var storage = new Storage(0, [], 0, 0, 0, 0,
        function(group) { return group.id; });

    var menu = MenuNodes.createSmallButtonContext("admin.resources",
                                                  _("Resources"));
    MenuNodes.createSmallButton(menu, "admin.resources.new", _("New"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        function() {
            page.addNew({ display_name: _("New resource") });
        });
    MenuNodes.createSmallButton(menu, "admin.resources.delete", _("Delete"),
        getFullImgSrc("img/dummy.gif"), getFullImgSrc("img/dummy.gif"),
        confirmDelete);
    function confirmDelete() {
        if (!selection.count) return;
        newConfirm(ngettext("Delete Resource", "Delete Resources",
                            storage.count),
            ngettext("Are you sure you want to delete the selected resource?",
                     "Are you sure you want to delete the selected resources?",
                     selection.count),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        storage.newIterate(selection.getSelected(), emptyFunction,
            function(i, data) {
                ox.JSON.put(AjaxRoot + "/resource?action=delete&timestamp=" +
                    data.timestamp + "&session=" + session, { id: data.id },
                    (function(id) {
                        return function(reply) { grid.deleteIDs([id]); };
                    })(data.id));
            });
    }
    addMenuNode(menu.node, MenuNodes.FIXED, 31);
    changeDisplay(node.id, "admin.resources");

    menuarrows[node.id] = {};
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var deleteenabled = selection.count > 0;
        menuglobalzaehler = 0;
        menuarrows[node.id]["admin.resources"] = [];
        menu_display_contents(node.id, "admin.resources",
            true, "admin.resources.new");
        menu_display_contents(node.id, "admin.resources", deleteenabled,
            "admin.resources.delete");
    });

    page.addWidget(new ox.UI.Input(_("Resource name")), "name");
    page.addWidget(new ox.UI.Input(_("Displayed name")), "display_name");
    page.addWidget(new ox.UI.Input(_("Resource email")), "mailaddress");
    page.addWidget(new ox.UI.TextArea(_("Description")), "description");
    var timestamp = new ox.UI.Widget();
    timestamp.set = function(value) { this.value = value; };
    timestamp.get = function() { return this.value; };
    timestamp.setVisible = emptyFunction;
    timestamp.remove = emptyFunction;
    page.addWidget(timestamp, "timestamp");
};

//directlink access to this module
if (url && url.view == "configuration/admin/resources") {
    node.click();
}