/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

ox.gui.initToolBarNewWindowInfoStore = function() {

    var $p = ox.gui.initToolBarNewWindow();
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Window
         */
        "window_infostore": {
            "save": {
                title: _("Save"),
                icons: ["save.png"],
                big: true
               
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.infostore = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-infostore-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-infostore-main", _("File")).addTo(toolbar);
    
    // Section "save"
    section = new ox.gui.PanelMenuSection(_("Save")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_infostore, "infostore_new", ["save"]);
    
    // Section "cancel"
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_infostore, "infostore_new", ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    register("OX_View_Changed", function() {
        ox.ToolBarController.processSelection("default", false, [], true);
    });
    
    // event mapping
    var events = {
        "infostore_new-save" : "OX_SAVE_OBJECT",
        "infostore_new-cancel" : "OX_Cancel_Object"
    }
  
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function(id) {
        
        // regex matches
        var m;
        
        // defined by event?
        if (events[id] !== undefined) {
            // trigger
            triggerEvent(events[id]);
            return true;
        }
    });
    
    ox.desktop.validate();
    
    // initial redraw to update icon state
    triggerEvent("OX_View_Changed");
    ox.ToolBarController.processSelection("participants", false, [], true);
    ox.ToolBarController.processSelection("attachments", false, [], true);
};