/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

ox.gui.initToolBarNewWindowCalendar = function () {

    var $p = ox.gui.initToolBarNewWindow();
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New/Edit Appointment Window
         */
        "window_calendar": {
            "save": {
                title: _("Save"),
                icons: ["save.png"],
                big: true
            },
            "add-participant": {
                title: _("Add participant"),
                icons: ["member_add.png"],
                big: true,
                requires : function(){
                    return ox.api.config.get("participants.showDialog");
                },
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/calendar/new/add_participants", window);
                    }
                }
            },
            "add-external-participant": {
                title: _("Add external participant"),
                icons: ["distributionlist_extcontact.png"],
                big: true,
                requires : function(){
                    return ox.api.config.get("participants.showDialog");
                },
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/calendar/new/add_participants", window);
                    }
                }
            },
            "remove-participant": {
                title: _("Remove participant"),
                icons: ["member_remove.png"],
                big: true,
                selection: "participants",
                requires : function(ability){
                    return currentpath[1] === "participant" && 
                    ox.api.config.get("participants.showDialog") && ability.some;
                },
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/calendar/new/remove_participants", window);
                    }
                }
            },
            "attachment-add": {
                title: _("Add attachment"),
                icons: ["attachment_add.png"],
                selection: "attachments",
                requires: function() {
                    return ox.api.config.get('modules.infostore.module');
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/calendar/new/add_attachment", window);
                    }
                }
            },
            "attachment-remove": {
                title: _("Remove attachment"),
                icons: ["attachment_remove.png"],
                selection: "attachments",
                requires: function(ability, selection) {
                    return currentpath[1] === "attachment" &&
                        ox.api.config.get('modules.infostore.module') &&
                        ability.some;
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", 
                                "modules/calendar/new/delete_attachment", window);
                    }
                }
            },
            "cancel": {
                 title: _("Cancel"),
                 icons: ["cancel.png"],
                 big: true
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.calendar = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-calendar-menu",
            showSectionNames: false
        })
    );
    
    // new
    tab = tabs.newCalendarWindow = new ox.gui.PanelMenu(
        "window-calendar-main", _("Appointment")).addTo(toolbar);
    // "save" section
    section = new ox.gui.PanelMenuSection(_("New")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_calendar, "calendar_new",
        ["save"]);
    // "participant" section
    section = new ox.gui.PanelMenuSection(_("Participants")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_calendar, "calendar_new",
        ["add-participant", "add-external-participant", "remove-participant"]);
    // "attachment" section
    section = new ox.gui.PanelMenuSection(_("Attachments")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_calendar, "calendar_new",
        ["attachment-add", "attachment-remove"]);
    // "cancel" section
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_calendar, "calendar_new",
        ["cancel"]);
    
    register("OX_View_Changed", function() {
        ox.ToolBarController.processSelection("default", false, [], true);
        ox.ToolBarController.processSelection("participants", false,
            newAppointment.participants.participantsGridBig.selection.
                getSelected(),
            true);
        ox.ToolBarController.processSelection("attachments", false,
            newAppointment.attachmentGrid ?
                newAppointment.attachmentGrid.liveGrid.selection.getSelected() :
                [],
            true);
    });
    
    // event mapping
    var events = {
        "calendar_new-save" : "OX_SAVE_OBJECT",
        "calendar_new-add-participant" : "OX_Object_Add_Participant",
        "calendar_new-add-external-participant" : "OX_Object_Open_External",
        "calendar_new-remove-participant" : "OX_Object_Participant_Delete",
        "calendar_new-cancel" : "OX_Cancel_Object",
        "calendar_new-attachment-add" : "OX_Object_Add_Attachment", 
        "calendar_new-attachment-remove" : "OX_Object_Attachment_Delete"
    };
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {        
        // defined by event?
        if (events[id] !== undefined) {
            // add (external) participant?
            if (id === "calendar_new-add-participant" || id === "calendar_new-add-external-participant") {
                // change tab
                changeView("calendar_new/participant");
            } else if (id === "calendar_new-attachment-add") {
                // change tab
                changeView("calendar_new/attachment");
            }
            // trigger
            triggerEvent(events[id]);
            return true;
        }
    });
    
       
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    ox.desktop.validate();
    triggerEvent("OX_View_Changed");
    ox.ToolBarController.processSelection("participants", false, [], true);
    ox.ToolBarController.processSelection("attachments", false, [], true);
};