
/*global ox : true, jQuery, Class, $, _, resizeEvents, getFullImgSrc, activefolder */

/**
 * @namespace
 */
ox = ox !== undefined ? ox : {};

/**
 * @namespace
 */
ox.gui = {
    themePath: getFullImgSrc("")
};

/**
 * Simple JavaScript Inheritance -- John Resig
 * adopted from http://ejohn.org/blog/simple-javascript-inheritance/
 */

(function () {
    
    var constructing = false, fnTest = /xyz/.test(function (xyz) {
        return xyz;
    }) ? /\b_super\b/ : /.*/;
    
    var $ = jQuery;

    // The base Class implementation (does nothing)
    this.Class = function () {
    };

    // Create a new Class that inherits from this class
    this.Class.extend = function (prop) {
        
        var _super = this.prototype;

        // Instantiate a base class (but only create the instance,
        // don't run the "construct" constructor)
        constructing = true;
        var prototype = new this();
        constructing = false;
        
        // allow functions
        if (typeof prop === "function") {
            // create tmp object
            var obj = {};
            // execute function bound to tmp object
            $.proxy(prop, obj)();
            // return obj (which is now changed)
            prop = obj;
        }

        // factory
        var factory = function (name, fn) {
            return function () {
                var tmp = this._super;
                // Add a new ._super() method that is the same method
                // but on the super-class
                this._super = _super[name];
                // The method only need to be bound temporarily, so we
                // remove it when we're done executing
                var ret = fn.apply(this, arguments);
                this._super = tmp;
                return ret;
            };
        };
        
        // Copy the properties over onto the new prototype
        for (var name in prop) {
            // Check if we're overwriting an existing function
            prototype[name] = $.isFunction(prop[name]) && $.isFunction(_super[name]) && fnTest.test(prop[name]) ? factory(name, prop[name]) : prop[name];
        }
        
        // add clone
        prototype.getConstructor = function () {
            return Class;
        };

        // The dummy class constructor
        var Class = function () {
            // All construction is actually done in the "construct" method
            if (!constructing && this.construct) {
                this.construct.apply(this, arguments);
            }
        };

        // Populate our constructed prototype object
        Class.prototype = prototype;
        // Enforce the constructor to be what we expect
        Class.constructor = Class;
        // And make this class extendable
        Class.extend = arguments.callee;

        return Class;
    };
}());

// helper

var $handleContextMenu = function (e) {
    //var e = event || window.event;
    var tag = e.target.tagName;
    var type = e.target.type || "";
    if (tag === "INPUT" && type.search(/^(text|password)$/i) >= 0) {
        return true;
    } else {
        e.preventDefault();
        e.stopPropagation();
        return false;
    }
};

var $handleSelection = function (event) {
    var e = $.event.fix(event || window.event);
    var tag = e.target.tagName;
    var type = e.target.type || "";
    if (tag === "INPUT" && type.search(/^(text|password)$/i) >= 0) {
        return true;
    } else {
        e.preventDefault();
        e.stopPropagation();
        return false;
    }
};

/**
 * Callback wrapper
 */
ox.call = function () {
    var args = $.makeArray(arguments);
    var callback = args.shift();
    if (typeof callback === "function") {
        callback.apply(this, args);
    }
};

/**
 * jQuery plugin
 */
$.fn.intoViewport = function (pane) {
    if (!pane) { return this; }
    var height = $(pane).outerHeight() || 0;
    var top = $(pane).offset().top || 0;
    var y = 0;
    // IE sometimes crashes so...
    try {
        y = this.offset().top;
    } catch (e) {
    }
    var scrollTop = $(pane).scrollTop() || 0;
    // check viewport
    if (y < top) {
        // above viewport
        $(pane).scrollTop(scrollTop+(y-top)-Math.round(height/2));
    } else if (y > top+height-30) {
        // below viewport
        $(pane).scrollTop(scrollTop+(y-(top+height))+Math.round(height/2));
    }
    return this;
};

/**
 * Mousewheel support
 */

(function($) {

    // handler
    var handler = function (event) {
        
        // get event
        var e = event || window.event;
        
        // fix event object
        e = $.event.fix(e);
        
        // set properties
        e.type = "mousewheel";
        e.delta = 0;
        e.deltaSign = 0;
        
        // get delta
        if (e.wheelDelta) {
            e.delta = e.wheelDelta / 120;
        }
        if (e.detail) {
            e.delta = -e.detail / 3;
        }
        
        // signed delta
        if (e.delta !== 0) {
            e.deltaSign = e.delta / Math.abs(e.delta);
        }
        
        // go!
        return $.event.handle.apply(this, [e]);
    };
    
    // event type
    var type = ox.browser.Gecko ? "DOMMouseScroll" : "mousewheel";
    
    // setup/teardown
    $.event.special.mousewheel = {
        setup: function () {
            // add listener
            if (this.addEventListener) {
                // Firefox, Safari, etc.
                this.addEventListener(type, handler, false);
            } else {
                // IE specific
                this.onmousewheel = handler;
            }
        },
        
        teardown: function () {
            // remove listener
            if (this.removeEventListener) {
                // Firefox, Safari, etc.
                this.removeEventListener(type, handler, false);
            } else {
                this.onmousewheel = null;
            }
        }
    };

}(jQuery));
