/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */


function RightsHandling () {
	this.rightshandling_module;
	this.realmodule;
	this.cbyes;
	this.cbno;
	this.newfolder;
	this.object;
	
}
RightsHandling.prototype = {
	checkRights : function(module,folder,object,cbyes,cbno) {

		var Self=this;
		this.cbyes=cbyes;
		this.cbno=cbno;
		this.object=object;
		this.rightshandling_module=module;
		this.realmodule=module;
		if(this.realmodule=="distributionlist") {
			this.realmodule="contacts";
		}
		function checkcreateRight(data) {
			if(data.module != Self.realmodule) {
				Self.newfolder=configGetKey("folder."+Self.realmodule);
				Self.commityes();			
			} 
			else {
				var myrights = ox.api.folder.derive("permissions", data, 0).bit;
				if(myrights>=2) {
					Self.newfolder=data.id;
					Self.commityes();					
				} else {
					Self.newfolder=configGetKey("folder."+Self.realmodule);
					Self.openWindow();					
				}
			}	
		}
		if(!folder) {
			if(object && object.folder_id) {
				folder=object.folder_id;
			}
			else if(!activefolder) {
				folder=configGetKey("folder."+Self.realmodule);
			} else {
				folder=activefolder;
			}
		}
		ox.api.folder.get({
		    folder: folder,
		    success: checkcreateRight
		});
	},
	openWindow : function() {
	    ox.api.setModal(true);
//		showNode("modal-dialog");
//		$("modal-dialog").style.display="block";
		showNode("rightshandling_window");
		centerPopupWindow($("rightshandling_window"));
		$("rightshandling_window").style.display="block";
	},
	commityes : function() {
		if(!this.object) {
			this.object = {};
		} 
		this.object.folder_id=this.newfolder;
		if(!this.cbyes) {
			triggerEvent("OX_Create_Object",this.rightshandling_module,this.newfolder,this.object);
		} else {
			this.cbyes(this.rightshandling_module,this.newfolder,this.object);
		}
		this.closeWindow();
	},
	commitno : function() {
		this.closeWindow();
	},
	closeWindow : function() {
		rightshandling_module=null;
		hideNode("rightshandling_window");
		$("rightshandling_window").style.display="none";
		var childs=	$("modal-dialog").childNodes;
		var closeall=true;
		for(var i=0;i<childs.length;i++) {
			if(childs[i].tagName && childs[i].tagName == "DIV") {
				if(childs[i].style.display && childs[i].style.display != "none" ) {
					closeall=false;
				}
			}
		}
		if(closeall) {
		    ox.api.setModal(false);
//			hideNode("modal-dialog");
//			$("modal-dialog").style.display="none";
		}
	}
};
var rightshandler=new RightsHandling();
register("Loaded",function() {
	addOnClose($('rightshandling_window'),function () { rightshandler.commitno(); });
});
register("Loaded",function() {
	if($('acceptdeny_object')) {
		addOnClose($('acceptdeny_object'),function () { rightshandler.commitno(); });
	}
});
fileloaded();