/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
registerModule("portal", _("Start Page"), 1);

var	bPortalConfigChanged = false;

var oPortalObject = null;

registerView("portal",
	function() { showNode("portal"); }, 
	function() { 
		if(oPortalObject != null)			
		{	
			if(bPortalConfigChanged)
			{
				oPortalObject.rebuild_page();
			}
			else
			{
				resizePortalHeaders();
				oPortalObject.update();			
			}
			
			
			ox.api.ui.setFolder();
		}
		else
		{			
			oPortalObject = new cPortal();
			register("OX_Refresh",portalUpdate);
		}
		window.onbeforeunload = unloadMessageMainLogin;		
		resizeEvents.register("Resized",resizePortalHeaders);	
	 }, 
	function() {
		window.onbeforeunload = unloadMessageMainLogin;
		resizeEvents.unregister("Resized",resizePortalHeaders);			
	},
	function() {		
		oPortalObject.disable();
		hideNode("portal");
	},function () {	
	});

function portalUpdate(){
	oPortalObject.update();
}
register('OX_Portal_Click_Item',fn_clickedItem);


register('OX_Configuration_Changed',function (param)
									{
										if(param && (param == 'configuration/portal/layout'))	
												bPortalConfigChanged = true;
									});

function fn_clickedItem(sModule,oObj)
{
	OXCache.newRequest(null, sModule, { objects: [oObj] }, null, function() {
	    triggerEvent("OX_Direct_Linking",sModule,oObj);
	});
}

function resizePortalHeaders()
{		
	if(oPortalObject != null)
		oPortalObject.resize($('portal').offsetWidth);
}

function doAjaxMultiplePortalRequest(aRequests, callback) {
    if (aRequests && aRequests.length > 0) {
        (new JSON()).put(AjaxRoot + '/multiple?session=' + session, aRequests, null, callback);
    } else {
        ox.util.call(callback, []);
    }
}

fileloaded();