/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * 
 */
 
function RoutingPlanner() {
	this.routingObjects = new Array();
	this.startAddress = {};
	
	this.countries = {"":"please select"/*i18n*/,"AF":"Afghanistan"/*i18n*/,"AX":"Åland Islands"/*i18n*/,"AL":"Albania"/*i18n*/,"DZ":"Algeria"/*i18n*/,
		"AS":"American Samoa"/*i18n*/,"AD":"Andorra"/*i18n*/,"AO":"Angola"/*i18n*/,"AI":"Anguilla"/*i18n*/,"AQ":"Antarctica"/*i18n*/,
		"AG":"Antigua and Barbuda"/*i18n*/,"AR":"Argentina"/*i18n*/,"AM":"Armenia"/*i18n*/,"AW":"Aruba"/*i18n*/,"AU":"Australia"/*i18n*/,
		"AT":"Austria"/*i18n*/,"AZ":"Azerbaijan"/*i18n*/,"BS":"Bahamas"/*i18n*/,"BH":"Bahrain"/*i18n*/,"BD":"Bangladesh"/*i18n*/,"BB":"Barbados"/*i18n*/,
		"BY":"Belarus"/*i18n*/,"BE":"Belgium"/*i18n*/,"BZ":"Belize"/*i18n*/,"BJ":"Benin"/*i18n*/,"BM":"Bermuda"/*i18n*/,"BT":"Bhutan"/*i18n*/,
		"BO":"Bolivia"/*i18n*/,"BA":"Bosnia and Herzegovina"/*i18n*/,"BW":"Botswana"/*i18n*/,"BV":"Bouvet Island"/*i18n*/,"BR":"Brazil"/*i18n*/,
		"IO":"British Indian Ocean Territory"/*i18n*/,"BN":"Brunei Darussalam"/*i18n*/,"BG":"Bulgaria"/*i18n*/,"BF":"Burkina Faso"/*i18n*/,
		"BI":"Burundi"/*i18n*/,"KH":"Cambodia"/*i18n*/,"CM":"Cameroon"/*i18n*/,"CA":"Canada"/*i18n*/,"CV":"Cape Verde"/*i18n*/,
		"KY":"Cayman Islands"/*i18n*/,"CF":"Central African Republic"/*i18n*/,"TD":"Chad"/*i18n*/,"CL":"Chile"/*i18n*/,"CN":"China"/*i18n*/,
		"CX":"Christmas Island"/*i18n*/,"CC":"Cocos (Keeling) Islands"/*i18n*/,"CO":"Colombia"/*i18n*/,"KM":"Comoros"/*i18n*/,"CG":"Congo"/*i18n*/,
		"CD":"Congo"/*i18n*/,"CK":"Cook Islands"/*i18n*/,"CR":"Costa Rica"/*i18n*/,"CI":"Cote d'Ivoire"/*i18n*/,"HR":"Croatia"/*i18n*/,
		"CU":"Cuba"/*i18n*/,"CY":"Cyprus"/*i18n*/,"CZ":"Czech Republic"/*i18n*/,"DK":"Denmark"/*i18n*/,"DJ":"Djibouti"/*i18n*/,
		"DM":"Dominica"/*i18n*/,"DO":"Dominican Republic"/*i18n*/,"EC":"Ecuador"/*i18n*/,"EG":"Egypt"/*i18n*/,"SV":"El Salvador"/*i18n*/,
		"GQ":"Equatorial Guinea"/*i18n*/,"ER":"Eritrea"/*i18n*/,"EE":"Estonia"/*i18n*/,"ET":"Ethiopia"/*i18n*/,"FK":"Falkland Islands (Malvinas)"/*i18n*/,
		"FO":"Faroe Islands"/*i18n*/,"FJ":"Fiji"/*i18n*/,"FI":"Finland"/*i18n*/,"FR":"France"/*i18n*/,"GF":"French Guiana"/*i18n*/,
		"PF":"French Polynesia"/*i18n*/,"TF":"French Southern Territories"/*i18n*/,"GA":"Gabon"/*i18n*/,"GM":"Gambia"/*i18n*/,"GE":"Georgia"/*i18n*/,
		"DE":"Germany"/*i18n*/,"GH":"Ghana"/*i18n*/,"GI":"Gibraltar"/*i18n*/,"GR":"Greece"/*i18n*/,"GL":"Greenland"/*i18n*/,
		"GD":"Grenada"/*i18n*/,"GP":"Guadeloupe"/*i18n*/,"GU":"Guam"/*i18n*/,"GT":"Guatemala"/*i18n*/,"GG":"Guernsey"/*i18n*/,
		"GN":"Guinea"/*i18n*/,"GW":"Guinea-Bissau"/*i18n*/,"GY":"Guyana"/*i18n*/,"HT":"Haiti"/*i18n*/,"HM":"Heard Island and McDonald Islands"/*i18n*/,
		"VA":"Holy See (Vatican City State)"/*i18n*/,"HN":"Honduras"/*i18n*/,"HK":"Hong Kong"/*i18n*/,"HU":"Hungary"/*i18n*/,"IS":"Iceland"/*i18n*/,
		"IN":"India"/*i18n*/,"ID":"Indonesia"/*i18n*/,"IR":"Iran"/*i18n*/,"IQ":"Iraq"/*i18n*/,"IE":"Ireland"/*i18n*/,
		"IM":"Isle of Man"/*i18n*/,"IL":"Israel"/*i18n*/,"IT":"Italy"/*i18n*/,"JM":"Jamaica"/*i18n*/,"JP":"Japan"/*i18n*/,
		"JE":"Jersey"/*i18n*/,"JO":"Jordan"/*i18n*/,"KZ":"Kazakhstan"/*i18n*/,"KE":"Kenya"/*i18n*/,"KI":"Kiribati"/*i18n*/,
		"KP":"Korea, Democratic People's Republic of"/*i18n*/,"KR":"Korea, Republic of"/*i18n*/,"KW":"Kuwait"/*i18n*/,"KG":"Kyrgyzstan"/*i18n*/,"LA":"Lao People's Democratic Republic"/*i18n*/,
		"LV":"Latvia"/*i18n*/,"LB":"Lebanon"/*i18n*/,"LS":"Lesotho"/*i18n*/,"LR":"Liberia"/*i18n*/,"LY":"Libyan Arab Jamahiriya"/*i18n*/,
		"LI":"Liechtenstein"/*i18n*/,"LT":"Lithuania"/*i18n*/,"LU":"Luxembourg"/*i18n*/,"MO":"Macao"/*i18n*/,"MK":"Macedonia"/*i18n*/,
		"MG":"Madagascar"/*i18n*/,"MW":"Malawi"/*i18n*/,"MY":"Malaysia"/*i18n*/,"MV":"Maldives"/*i18n*/,"ML":"Mali"/*i18n*/,
		"MT":"Malta"/*i18n*/,"MH":"Marshall Islands"/*i18n*/,"MQ":"Martinique"/*i18n*/,"MR":"Mauritania"/*i18n*/,"MU":"Mauritius"/*i18n*/,
		"YT":"Mayotte"/*i18n*/,"MX":"Mexico"/*i18n*/,"FM":"Micronesia"/*i18n*/,"MD":"Moldova"/*i18n*/,"MC":"Monaco"/*i18n*/,
		"MN":"Mongolia"/*i18n*/,"ME":"Montenegro"/*i18n*/,"MS":"Montserrat"/*i18n*/,"MA":"Morocco"/*i18n*/,"MZ":"Mozambique"/*i18n*/,
		"MM":"Myanmar"/*i18n*/,"NA":"Namibia"/*i18n*/,"NR":"Nauru"/*i18n*/,"NP":"Nepal"/*i18n*/,"NL":"Netherlands"/*i18n*/,
		"AN":"Netherlands Antilles"/*i18n*/,"NC":"New Caledonia"/*i18n*/,"NZ":"New Zealand"/*i18n*/,"NI":"Nicaragua"/*i18n*/,"NE":"Niger"/*i18n*/,
		"NG":"Nigeria"/*i18n*/,"NU":"Niue"/*i18n*/,"NF":"Norfolk Island"/*i18n*/,"MP":"Northern Mariana Islands"/*i18n*/,"NO":"Norway"/*i18n*/,
		"OM":"Oman"/*i18n*/,"PK":"Pakistan"/*i18n*/,"PW":"Palau"/*i18n*/,"PS":"Palestinian Territory, Occupied"/*i18n*/,"PA":"Panama"/*i18n*/,
		"PG":"Papua New Guinea"/*i18n*/,"PY":"Paraguay"/*i18n*/,"PE":"Peru"/*i18n*/,"PH":"Philippines"/*i18n*/,"PN":"Pitcairn"/*i18n*/,
		"PL":"Poland"/*i18n*/,"PT":"Portugal"/*i18n*/,"PR":"Puerto Rico"/*i18n*/,"QA":"Qatar"/*i18n*/,"RE":"Reunion"/*i18n*/,
		"RO":"Romania"/*i18n*/,"RU":"Russian Federation"/*i18n*/,"RW":"Rwanda"/*i18n*/,"BL":"Saint Barthélemy"/*i18n*/,"SH":"Saint Helena"/*i18n*/,
		"KN":"Saint Kitts and Nevis"/*i18n*/,"LC":"Saint Lucia"/*i18n*/,"MF":"Saint Martin (French part)"/*i18n*/,"PM":"Saint Pierre and Miquelon"/*i18n*/,"VC":"Saint Vincent and the Grenadines"/*i18n*/,
		"WS":"Samoa"/*i18n*/,"SM":"San Marino"/*i18n*/,"ST":"Sao Tome and Principe"/*i18n*/,"SA":"Saudi Arabia"/*i18n*/,"SN":"Senegal"/*i18n*/,
		"RS":"Serbia"/*i18n*/,"SC":"Seychelles"/*i18n*/,"SL":"Sierra Leone"/*i18n*/,"SG":"Singapore"/*i18n*/,"SK":"Slovakia"/*i18n*/,
		"SI":"Slovenia"/*i18n*/,"SB":"Solomon Islands"/*i18n*/,"SO":"Somalia"/*i18n*/,"ZA":"South Africa"/*i18n*/,"GS":"South Georgia and the South Sandwich Islands"/*i18n*/,
		"ES":"Spain"/*i18n*/,"LK":"Sri Lanka"/*i18n*/,"SD":"Sudan"/*i18n*/,"SR":"Suriname"/*i18n*/,"SJ":"Svalbard and Jan Mayen"/*i18n*/,
		"SZ":"Swaziland"/*i18n*/,"SE":"Sweden"/*i18n*/,"CH":"Switzerland"/*i18n*/,"SY":"Syrian Arab Republic"/*i18n*/,"TW":"Taiwan"/*i18n*/,
		"TJ":"Tajikistan"/*i18n*/,"TZ":"Tanzania"/*i18n*/,"TH":"Thailand"/*i18n*/,"TL":"Timor-Leste"/*i18n*/,"TG":"Togo"/*i18n*/,
		"TK":"Tokelau"/*i18n*/,"TO":"Tonga"/*i18n*/,"TT":"Trinidad and Tobago"/*i18n*/,"TN":"Tunisia"/*i18n*/,"TR":"Turkey"/*i18n*/,
		"TM":"Turkmenistan"/*i18n*/,"TC":"Turks and Caicos Islands"/*i18n*/,"TV":"Tuvalu"/*i18n*/,"UG":"Uganda"/*i18n*/,"UA":"Ukraine"/*i18n*/,
		"AE":"United Arab Emirates"/*i18n*/,"GB":"United Kingdom"/*i18n*/,"US":"United States"/*i18n*/,"UM":"United States Minor Outlying Islands"/*i18n*/,"UY":"Uruguay"/*i18n*/,
		"UZ":"Uzbekistan"/*i18n*/,"VU":"Vanuatu"/*i18n*/,"VE":"Venezuela"/*i18n*/,"VN":"Viet Nam"/*i18n*/,"VG":"Virgin Islands, British"/*i18n*/,
		"VI":"Virgin Islands, U.S."/*i18n*/,"WF":"Wallis and Futuna"/*i18n*/,"EH":"Western Sahara"/*i18n*/,"YE":"Yemen"/*i18n*/,"ZM":"Zambia"/*i18n*/,
		"ZW":"Zimbabwe"/*i18n*/	
	};
	//http://en.wikipedia.org/wiki/ISO_3166-1
}
RoutingPlanner.prototype = {
	
	registerRoutingPlanner : function(obj) {
		this.routingObjects.push(obj);
	},
	buildCombobox : function(countryFrom, countryTo) {
		
		var sortedAfterTranslation = true;
		
		if(!$("comboRoutingPlanning") || this.routingObjects.length == 0) return;
		objRoutingPlanner.comboRoutePlanning = new ComboBox3(window, "comboRoutingPlanning", "10em", 0, true, "change_routeplannerLogo", 3);
		for(var r=0; r < this.routingObjects.length; r++) {
            objRoutingPlanner.comboRoutePlanning.addElement(
                noI18n(this.routingObjects[r].name),
                this.routingObjects[r].name);
		}		
		objRoutingPlanner.comboRoutePlanning.getDomNode(); 
				
		if(!$("station0.country")) return;
		objRoutingPlanner.country0  = new ComboBox3(window, "station0.country", "10em", 0, true, null, 7);
		for(var key in this.countries) {
			objRoutingPlanner.country0.addElement(this.countries[key],key);
		}		
		objRoutingPlanner.country0.getDomNode(sortedAfterTranslation);
		//objRoutingPlanner.country0.sorti18nValue();
		
		if(countryFrom)
			objRoutingPlanner.country0.setValue(countryFrom);
		
		
		if(!$("station1.country")) return;
		objRoutingPlanner.country1  = new ComboBox3(window, "station1.country", "10em", 0, true, null, 7);
		for(var key in this.countries) {
            objRoutingPlanner.country1.addElement(_(this.countries[key]), key);
		}		
		
		objRoutingPlanner.country1.getDomNode(sortedAfterTranslation);
		//objRoutingPlanner.country1.sorti18nValue();
		if(countryTo) {
			objRoutingPlanner.country1.setValue(countryTo);
		}
	},
	showForm : function(indexSearch) {
		if(this.routingObjects.length == 0) {
			triggerEvent("OX_New_Error", 4, _("No route planner registered."));
			return false;
		}
		var properties = 0;
		for(fieldLabel in objRoutingPlanner.endAddress[indexSearch])
			properties++;
			
		if (properties > 0)	{	
			$('contactPreviewMapDiv').style.display = 'block';
			$("station1.street").value = objRoutingPlanner.endAddress[indexSearch].street || _('Street');
			$("station1.zip").value = objRoutingPlanner.endAddress[indexSearch].zip || _('ZIP');
			$("station1.city").value = objRoutingPlanner.endAddress[indexSearch].city || _('City');
			
			//objRoutingPlanner.country1.setValue(objRoutingPlanner.endAddress[indexSearch].country)
			objRoutingPlanner.buildCombobox(objRoutingPlanner.startAddress.country, objRoutingPlanner.endAddress[indexSearch].country);
		}
	},
	setEndAdress : function(key, urlLink) {
		objRoutingPlanner.endAddress[urlLink[2]] = urlLink[1][urlLink[0].selected];		
		var properties = 0;
		for(fieldLabel in urlLink[1][urlLink[0].selected])
			properties++;
		if(properties == 0)	{
			$('contactImgShowMap'+urlLink[2]).className = "mapLinkNoActive";
			$('contactImgShowMap'+urlLink[2]).src = getFullImgSrc("img/menu/adress1_d.gif");
		}
		else {
			$('contactImgShowMap'+urlLink[2]).className = "mapLinkActive";
			$('contactImgShowMap'+urlLink[2]).src = getFullImgSrc("img/menu/adress1_n.gif");
		}
	}, 
	setStartAdress : function() {
		(new JSON()).get(AjaxRoot + "/user?action=get&session=" + session +"&id="+configGetKey('identifier')+"&"
		,null,
		function(reply) {
			if(reply && reply.data) {
				contactAdressToSearch[2] = new Object();
				$("station0.street").value = reply.data["street_business"] || _('Street');
				$("station0.zip").value = reply.data["postal_code_business"] || _('ZIP');
				$("station0.city").value = reply.data["city_business"] || _('City');
				
				objRoutingPlanner.startAddress.street = reply.data["street_business"] || "";
				objRoutingPlanner.startAddress.zip = reply.data["postal_code_business"] || "";
				objRoutingPlanner.startAddress.city = reply.data["city_business"] || "";
				objRoutingPlanner.startAddress.country = reply.data["country_business"] || "";
				
			}
			objRoutingPlanner.buildCombobox(objRoutingPlanner.startAddress.country);
		});
	},
	sendRoutingRequest : function() {
		var indexRoutinPlaner = objRoutingPlanner.comboRoutePlanning.getSelectedIndex();
		var routingObject = {};
		
		routingObject.fromStreet = ($("station0.street").value == _('Street')) ? "" : $("station0.street").value;
		routingObject.fromZip = ($("station0.zip").value == _('ZIP')) ? "" : $("station0.zip").value;
		routingObject.fromCity = ($("station0.city").value == _('City')) ? "" : $("station0.city").value;
		
		if(objRoutingPlanner.country0.selected == 0)
			routingObject.fromCountry = "";
		else
			routingObject.fromCountry = objRoutingPlanner.country0.getKey();
		
		routingObject.toStreet = ($("station1.street").value == _('Street')) ? "" : $("station1.street").value;
		routingObject.toZip = ($("station1.zip").value == _('ZIP')) ? "" : $("station1.zip").value;
		routingObject.toCity = ($("station1.city").value == _('City')) ? "" : $("station1.city").value;
				
		if(objRoutingPlanner.country1.selected == 0)
			routingObject.toCountry = "";
		else
			routingObject.toCountry = objRoutingPlanner.country1.getKey();
		
		routeData = {};
		routeData.Data = routingObject;
		this.routingObjects[indexRoutinPlaner].getDirection(routeData);

		
	}, 
	changeLogo : function() {
		var indexRoutinPlaner = objRoutingPlanner.comboRoutePlanning.getSelectedIndex();			
		$("routeplannerLogo").src = objRoutingPlanner.routingObjects[indexRoutinPlaner].logo;
	}
	
}

var objRoutingPlanner = new RoutingPlanner();
/* enable plugin Routing Planner (true|false). Later it will be a config param */
objRoutingPlanner.active = false;

objRoutingPlanner.endAddress = new Array();
objRoutingPlanner.comboRoutePlanning = null;
objRoutingPlanner.country0 = null;
objRoutingPlanner.country1 = null;

if(objRoutingPlanner.active) {
	register("OX_Configuration_Loaded",function() {	
		addOnClose($('contactPreviewMapDiv'),function () { closeMapsDivs(); });
		objRoutingPlanner.setStartAdress();
		
	});
	register("routePlaner_set_end_address", objRoutingPlanner.setEndAdress);
	register("change_routeplannerLogo", objRoutingPlanner.changeLogo);
} 
fileloaded();