/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2010 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

function ConfigCategories() {
	this.grid, this.selection = new Selection();
    this.storage = new Storage(0, [], 0, 0, 0, 0, function(data) { return data.name; }); 
}

ConfigCategories.prototype = {
	initGrid : function() {
		var self = this;
		this.grid = new LiveGrid([
		      { 
		          text: "Color", /*i18n*/
		          width: "6em",
		          i18n: true,
		          clear: function(div) {
			    	  if (div.firstChild)
		                  div.firstChild.className = "";
		              else
		                  div.appendChild(
		                		  newnode("div", 0, { className: "colorLabelCont bg hb" }));
		      	  },
		          set: function(div, data) {
		              if (div.firstChild)
		                  div.firstChild.className = "colorLabelCont bg hb colorLabel"+data.color;
		              else
		                  div.appendChild(
		                		  newnode("div", 0, 
		                				  { className: "colorLabelCont bg hb colorLabel" + data.color }));
		          }
		      },
		      {
		          text: "Name", /*i18n*/
		          i18n: true,
		          clear: LiveGrid.makeClear(""),		          
		          set: function(div, data) {        	
		              if (div.firstChild)
		                  div.firstChild.data = data.name;
		              else
		                  div.appendChild(document.createTextNode(data.name));
		          }
		      }
	      ], this.selection);
		
		this.grid.emptylivegridtext = "";
		this.grid.events.register("Selected", function() {
	    	// get selected signature
	    	var ids = self.grid.selection.getSelected();
	    	ox.ToolBarController.processSelection("categories", false, ids);
	    });
		this.grid.events.register("Activated", function(ids) {           
	            if (ids && ids.length > 0) {
	                triggerEvent("OX_Configuration_Edit_Tags");
	            }
	        }
	    );
		this.grid.events.register("Delete", 
	        function (ids){
	            // todo
	        }
	    );
	    
	    $("cms_tags_header").appendChild(this.grid.getHeader());
	    this.grid.getTable($("cms_tags_grid"));
	},
	
	enableGrid : function() {
		cnf_Categories.storage.remove(0, cnf_Categories.storage.ids.length);
		this.storage.append(ox.categories.list());
		this.grid.enable(this.storage);
	}, 
	
	disableGrid : function() {
		this.grid.disable();
	},
	
	addCategory : function() {
		ox.categories.ui.add.open(null, cnf_Categories.storeCategory);
	},
	
	editCategory : function() {
		var id = cnf_Categories.grid.selection.getSelected()[0];
		if (id) {
			var obj = cnf_Categories.grid.storage.data.data[id];
			if (obj) {
				ox.categories.ui.add.open(obj, cnf_Categories.storeCategory);
			}
		}
	},
		
	storeCategory : function(category) {
		if (!category) return;
				
		// either edit or new!?
		if (category.id) {
			cnf_Categories.grid.storage.localUpdate([category.id], function(index, object) {
	    		return category;
        	});
		} else {
			if (ox.categories.exists(category.name) ||
					cnf_Categories.grid.storage.indices[category.name]) return;
			category.active = true;			
			cnf_Categories.grid.storage.append([category]); // append to grid
		}
		configuration_changed_fields["gui"] = true;
	},
	
	removeCategory : function() {
		var ids = cnf_Categories.grid.selection.getSelected();
		if (ids && ids.length) {
			cnf_Categories.grid.storage.removeIDs(ids);
			configuration_changed_fields["gui"] = true;
		}
	},
		
	saveConfiguration : function() {
		if (configuration_changed_fields["gui"] && cnf_Categories.grid) {
			var grid = cnf_Categories.grid, selCat = [];
			// iterate through storage and get selected cats 
			grid.storage.newIterate(grid.storage.ids, emptyFunction, function(id, obj) {
				delete(obj.id);
				delete(obj.active);
				selCat.push(obj);
			}, function() {
				ox.categories.setCache(selCat);
				ox.categories.save();
			});			
		}
	},
	
	cancelConfiguration : function() {
		configuration_changed_fields["gui"] = false;
	}
		
}
var cnf_Categories = new ConfigCategories();

registerView("configuration/tags",
	function() { 
		showNode("config_tags"); 
		$("config_tags").style.display="block"; 
        
        // toolbar
        if (!configToolbars.categories) {
            configToolbars.categories =
                temporary.configuration.newToolbar(_("Categories"), [
                    temporary.configuration.saveButton,
                    { title: _("Categories"), buttons: [
                        {
                            title: _("Add"),
                            icons: ["img/menu/add_category.gif",
                                    "img/menu/add_category_d.gif"],
                            event: "OX_Configuration_Categories_Add"
                        }, {
                            title: _("Edit"),
                            icons: ["img/menu/edit.gif", "img/menu/edit_d.gif"],
                            event: "OX_Configuration_Categories_Edit",
                            selection: "categories",
                            requires: ["one"]
                        }, {
                            title: _("Remove"),
                            icons: ["img/menu/remove_category.gif",
                                    "img/menu/remove_category_d.gif"],
                            event: "OX_Configuration_Categories_Remove",
                            selection: "categories",
                            requires: ["some"]
                        }
                    ] }
                ], "categories");
            ox.ToolBarController.processSelection("categories", false, []);
        }
        temporary.configuration.showToolbar(configToolbars.categories);
	},
	function() { 
		setConfigPath($("config_tags_header"));
 	    register("OX_SAVE_OBJECT", cnf_Categories.saveConfiguration);
		register("OX_Cancel_Object", cnf_Categories.cancelConfiguration);
		register("OX_Configuration_Categories_Add", cnf_Categories.addCategory);
		register("OX_Configuration_Categories_Edit", cnf_Categories.editCategory);
		register("OX_Configuration_Categories_Remove", cnf_Categories.removeCategory);
		if (!cnf_Categories.grid) {
			cnf_Categories.initGrid();
		}
		cnf_Categories.enableGrid();
	},
	function() { 
 	    unregister("OX_SAVE_OBJECT", cnf_Categories.saveConfiguration);
		unregister("OX_Cancel_Object", cnf_Categories.cancelConfiguration);
		unregister("OX_Configuration_Categories_Add", cnf_Categories.addCategory);
		unregister("OX_Configuration_Categories_Edit", cnf_Categories.editCategory);
		unregister("OX_Configuration_Categories_Remove", cnf_Categories.removeCategory);
		cnf_Categories.disableGrid();
	},
	function() { 
		hideNode("config_tags"); 
		$("config_tags").style.display="none"; 
	},
	function() { }
);

fileloaded();