/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.event.mapper;

import java.util.Hashtable;
import org.eclipse.equinox.event.mapper.EventAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;

public class LogEntryAdapter
extends EventAdapter {
    public static final String TOPIC = "org/osgi/service/log/LogEntry";
    public static final String TIMESTAMP = "timestamp";
    public static final String MESSAGE = "message";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_ENTRY = "log.entry";
    private LogEntry entry;

    public LogEntryAdapter(LogEntry entry, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.entry = entry;
    }

    public Event convert() {
        ServiceReference ref;
        String topic = TOPIC;
        int level = this.entry.getLevel();
        switch (level) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                topic = String.valueOf(topic) + (47 + level);
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Bundle bundle = this.entry.getBundle();
        if (bundle == null) {
            throw new RuntimeException("LogEntry.getBundle() returns null");
        }
        this.putBundleProperties(properties, bundle);
        Throwable t = this.entry.getException();
        if (t != null) {
            this.putExceptionProperties(properties, t);
        }
        if ((ref = this.entry.getServiceReference()) != null) {
            this.putServiceReferenceProperties(properties, ref);
        }
        properties.put(LOG_ENTRY, this.entry);
        properties.put(LOG_LEVEL, new Integer(this.entry.getLevel()));
        if (this.entry.getMessage() != null) {
            properties.put(MESSAGE, this.entry.getMessage());
        }
        properties.put(TIMESTAMP, new Long(this.entry.getTime()));
        Event converted = new Event(topic, properties);
        return converted;
    }
}

